/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMetaDataContext
extends AbstractMetaDataContext {
    private volatile Map<String, AnnotationItem> annotations;
    private volatile Map<String, MetaDataItem> metaDataByName;
    private volatile AnnotationsItem cachedAnnotationsItem;
    private volatile MetaDatasItem cachedMetaDatasItem;
    private volatile Map<Signature, MetaDataRetrieval> cachedComponents;
    private volatile long validTime = super.getValidTime().getValidTime();
    private volatile Boolean empty;
    private volatile Map<ScopeLevel, MetaDataRetrieval> cachedScopedRetrievals;

    public CachingMetaDataContext(MetaDataRetrieval retrieval) {
        this(null, retrieval);
    }

    public CachingMetaDataContext(MetaDataContext parent, MetaDataRetrieval retrieval) {
        this(parent, Collections.singletonList(retrieval));
    }

    public CachingMetaDataContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        super(parent, retrievals);
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        if (this.cachedAnnotationsItem == null) {
            this.cachedAnnotationsItem = super.retrieveAnnotations();
        }
        return this.cachedAnnotationsItem;
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        AnnotationItem result;
        if (annotationType == null) {
            throw new IllegalArgumentException("Null annotationType");
        }
        String annotationName = annotationType.getName();
        long newValidTime = super.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.metaDataByName != null) {
                this.metaDataByName.clear();
            }
            this.validTime = newValidTime;
        }
        if (this.annotations != null && (result = this.annotations.get(annotationName)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.annotations.remove(annotationName);
        }
        if ((result = super.retrieveAnnotation(annotationType)) != null && result.isCachable()) {
            if (this.annotations == null) {
                this.annotations = new ConcurrentHashMap<String, AnnotationItem>();
            }
            this.annotations.put(annotationName, result);
        }
        return result;
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        if (this.cachedMetaDatasItem == null) {
            this.cachedMetaDatasItem = super.retrieveMetaData();
        }
        return this.cachedMetaDatasItem;
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        MetaDataItem result;
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        String name = type.getName();
        long newValidTime = super.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.metaDataByName != null) {
                this.metaDataByName.clear();
            }
            this.validTime = newValidTime;
        }
        if (this.metaDataByName != null && (result = this.metaDataByName.get(name)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.metaDataByName.remove(name);
        }
        if ((result = super.retrieveMetaData(type)) != null && result.isCachable()) {
            if (this.metaDataByName == null) {
                this.metaDataByName = new ConcurrentHashMap<String, MetaDataItem>();
            }
            this.metaDataByName.put(name, result);
        }
        return result;
    }

    @Override
    public MetaDataItem retrieveMetaData(String name) {
        MetaDataItem result;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        long newValidTime = super.getValidTime().getValidTime();
        if (this.validTime < newValidTime) {
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.metaDataByName != null) {
                this.metaDataByName.clear();
            }
            this.validTime = newValidTime;
        }
        if (this.metaDataByName != null && (result = this.metaDataByName.get(name)) != null) {
            if (result.isValid()) {
                return result;
            }
            this.metaDataByName.remove(name);
        }
        if ((result = super.retrieveMetaData(name)) != null && result.isCachable()) {
            if (this.metaDataByName == null) {
                this.metaDataByName = new ConcurrentHashMap<String, MetaDataItem>();
            }
            this.metaDataByName.put(name, result);
        }
        return result;
    }

    @Override
    public void append(MetaDataRetrieval retrieval) {
        super.append(retrieval);
        this.cachedComponents = null;
        this.empty = null;
        this.cachedScopedRetrievals = null;
    }

    @Override
    public void prepend(MetaDataRetrieval retrieval) {
        super.prepend(retrieval);
        this.cachedComponents = null;
        this.empty = null;
        this.cachedScopedRetrievals = null;
    }

    @Override
    public void remove(MetaDataRetrieval retrieval) {
        super.remove(retrieval);
        this.cachedComponents = null;
        this.empty = null;
        this.cachedScopedRetrievals = null;
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        MetaDataRetrieval retrieval;
        if (signature == null) {
            return null;
        }
        if (this.cachedComponents != null && (retrieval = this.cachedComponents.get(signature)) != null) {
            return retrieval;
        }
        retrieval = super.getComponentMetaDataRetrieval(signature);
        if (retrieval != null) {
            if (this.cachedComponents == null) {
                this.cachedComponents = new ConcurrentHashMap<Signature, MetaDataRetrieval>();
            }
            this.cachedComponents.put(signature, retrieval);
        }
        return retrieval;
    }

    @Override
    public boolean isEmpty() {
        if (this.empty == null) {
            this.empty = super.isEmpty();
        }
        return this.empty;
    }

    @Override
    public MetaDataRetrieval getScopedRetrieval(ScopeLevel level) {
        boolean update = this.cachedScopedRetrievals == null || !this.cachedScopedRetrievals.keySet().contains(level);
        return this.getCachedScopedRetrieval(level, update);
    }

    protected MetaDataRetrieval getCachedScopedRetrieval(ScopeLevel level, boolean update) {
        if (this.cachedScopedRetrievals == null) {
            this.cachedScopedRetrievals = new HashMap<ScopeLevel, MetaDataRetrieval>();
        }
        MetaDataRetrieval retrieval = this.cachedScopedRetrievals.get(level);
        if (update) {
            retrieval = super.getScopedRetrieval(level);
            this.cachedScopedRetrievals.put(level, retrieval);
        }
        return retrieval;
    }
}

