/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.metadata.plugins.loader.AbstractMutableMetaDataLoader;
import org.jboss.metadata.spi.ComponentMutableMetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.MemberInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableComponentMetaDataLoader
extends AbstractMutableMetaDataLoader
implements ComponentMutableMetaData {
    private volatile Map<Signature, MetaDataRetrieval> components;

    public AbstractMutableComponentMetaDataLoader() {
        this(false);
    }

    public AbstractMutableComponentMetaDataLoader(boolean restricted) {
        super(restricted);
    }

    public AbstractMutableComponentMetaDataLoader(ScopeKey key) {
        this(key, false);
    }

    public AbstractMutableComponentMetaDataLoader(ScopeKey key, boolean restricted) {
        super(key, restricted);
    }

    @Override
    public boolean isEmpty() {
        return AbstractMutableComponentMetaDataLoader.isNullOrEmpty(this.components);
    }

    protected static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    @Override
    public MetaDataRetrieval addComponentMetaDataRetrieval(Signature signature, MetaDataRetrieval component) {
        if (signature == null) {
            throw new IllegalArgumentException("Null signature");
        }
        if (this.components == null) {
            this.components = new ConcurrentHashMap<Signature, MetaDataRetrieval>();
        }
        return this.components.put(signature, component);
    }

    @Override
    public MetaDataRetrieval removeComponentMetaDataRetrieval(Signature signature) {
        if (signature == null) {
            throw new IllegalArgumentException("Null signature");
        }
        if (this.components == null) {
            return null;
        }
        return this.components.remove(signature);
    }

    @Override
    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(signature);
    }

    protected MutableMetaData initRetrieval(Signature signature) {
        MetaDataRetrieval result = this.getComponentMetaDataRetrieval(signature);
        if (result == null) {
            result = this.initComponentRetrieval(signature);
            this.addComponentMetaDataRetrieval(signature, result);
        }
        if (!(result instanceof MutableMetaData)) {
            throw new IllegalStateException("Component is not mutable: " + signature);
        }
        return (MutableMetaData)((Object)result);
    }

    protected abstract MetaDataRetrieval initComponentRetrieval(Signature var1);

    @Override
    public <T extends Annotation> T addAnnotation(Signature signature, T annotation) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.addAnnotation(annotation);
    }

    @Override
    public <T> T addMetaData(Signature signature, String name, T metaData, Class<T> type) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.addMetaData(name, metaData, type);
    }

    @Override
    public <T> T addMetaData(Signature signature, T metaData, Class<T> type) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.addMetaData(metaData, type);
    }

    @Override
    public <T extends Annotation> T removeAnnotation(Signature signature, Class<T> annotationType) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.removeAnnotation(annotationType);
    }

    @Override
    public <T> T removeMetaData(Signature signature, Class<T> type) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.removeMetaData(type);
    }

    @Override
    public <T> T removeMetaData(Signature signature, String name, Class<T> type) {
        MutableMetaData component = this.initRetrieval(signature);
        return component.removeMetaData(name, type);
    }

    @Override
    public <T extends Annotation> T addAnnotation(Member member, T annotation) {
        return this.addAnnotation(Signature.getSignature(member), annotation);
    }

    @Override
    public <T extends Annotation> T addAnnotation(MemberInfo member, T annotation) {
        return this.addAnnotation(Signature.getSignature(member), annotation);
    }

    @Override
    public <T> T addMetaData(Member member, String name, T metaData, Class<T> type) {
        return this.addMetaData(Signature.getSignature(member), name, metaData, type);
    }

    @Override
    public <T> T addMetaData(Member member, T metaData, Class<T> type) {
        return this.addMetaData(Signature.getSignature(member), metaData, type);
    }

    @Override
    public <T> T addMetaData(MemberInfo member, String name, T metaData, Class<T> type) {
        return this.addMetaData(Signature.getSignature(member), name, metaData, type);
    }

    @Override
    public <T> T addMetaData(MemberInfo member, T metaData, Class<T> type) {
        return this.addMetaData(Signature.getSignature(member), metaData, type);
    }

    @Override
    public <T extends Annotation> T removeAnnotation(Member member, Class<T> annotationType) {
        return this.removeAnnotation(Signature.getSignature(member), annotationType);
    }

    @Override
    public <T extends Annotation> T removeAnnotation(MemberInfo member, Class<T> annotationType) {
        return this.removeAnnotation(Signature.getSignature(member), annotationType);
    }

    @Override
    public <T> T removeMetaData(Member member, Class<T> type) {
        return this.removeMetaData(Signature.getSignature(member), type);
    }

    @Override
    public <T> T removeMetaData(Member member, String name, Class<T> type) {
        return this.removeMetaData(Signature.getSignature(member), name, type);
    }

    @Override
    public <T> T removeMetaData(MemberInfo member, Class<T> type) {
        return this.removeMetaData(Signature.getSignature(member), type);
    }

    @Override
    public <T> T removeMetaData(MemberInfo member, String name, Class<T> type) {
        return this.removeMetaData(Signature.getSignature(member), name, type);
    }
}

