/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.repository.visitor;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.metadata.spi.repository.MetaDataRepository;
import org.jboss.metadata.spi.repository.visitor.MetaDataRepositoryVisitor;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.scope.ScopeLevel;

public class FuzzyMetaDataRepositoryVisitor
implements MetaDataRepositoryVisitor {
    private Scope[] matchScopes;

    public FuzzyMetaDataRepositoryVisitor(ScopeKey matchKey) {
        if (matchKey != null) {
            Collection<Scope> testScopes = matchKey.getScopes();
            this.matchScopes = testScopes.toArray(new Scope[testScopes.size()]);
        }
    }

    public boolean matchScope(MetaDataRepository repository, ScopeKey key) {
        if (this.matchScopes == null || this.matchScopes.length == 0) {
            return true;
        }
        boolean match = false;
        int index = 0;
        Iterator<Scope> i = key.getScopes().iterator();
        Scope repositoryScope = i.next();
        Scope matchScope = this.matchScopes[index];
        while (true) {
            ScopeLevel repositoryLevel;
            ScopeLevel keyLevel;
            if ((keyLevel = matchScope.getScopeLevel()).compareTo(repositoryLevel = repositoryScope.getScopeLevel()) == 0) {
                if (matchScope.equals(repositoryScope)) {
                    match = true;
                } else {
                    match = false;
                    break;
                }
            }
            if (keyLevel.compareTo(repositoryLevel) <= 0) {
                if (++index == this.matchScopes.length) break;
                matchScope = this.matchScopes[index];
                continue;
            }
            if (!i.hasNext()) break;
            repositoryScope = i.next();
        }
        return match;
    }
}

