/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.server.ServerConstants;

public class AgentID
implements ServerConstants {
    private static SynchronizedLong id = new SynchronizedLong(0L);
    private static final Random rand = new Random(System.currentTimeMillis());

    public static String create() {
        String ipAddress = null;
        try {
            ipAddress = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InetAddress.getLocalHost().getHostAddress();
                }
            });
        }
        catch (PrivilegedActionException e) {
            ipAddress = "127.0.0.1";
        }
        String vmid = new VMID().toString().replace(':', 'x').replace('-', 'X') + rand.nextInt(100);
        return ipAddress + "/" + System.currentTimeMillis() + "/" + vmid + "/" + id.increment();
    }

    public static void main(String[] args) {
        for (int c = 0; c < 10; ++c) {
            System.out.println(AgentID.create());
        }
    }

    public static String get(MBeanServer server) {
        try {
            ObjectName name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String agentID = (String)server.getAttribute(name, "MBeanServerId");
            return agentID;
        }
        catch (Throwable t) {
            throw new Error("Cannot find the MBean server delegate: " + t.toString());
        }
    }
}

