/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class JMXExceptionDecoder {
    public static Throwable decode(Throwable t) {
        Throwable result = t;
        while (true) {
            if (result instanceof MBeanException) {
                result = ((MBeanException)result).getTargetException();
                continue;
            }
            if (result instanceof ReflectionException) {
                result = ((ReflectionException)result).getTargetException();
                continue;
            }
            if (result instanceof RuntimeOperationsException) {
                result = ((RuntimeOperationsException)result).getTargetException();
                continue;
            }
            if (result instanceof RuntimeMBeanException) {
                result = ((RuntimeMBeanException)result).getTargetException();
                continue;
            }
            if (!(result instanceof RuntimeErrorException)) break;
            result = ((RuntimeErrorException)result).getTargetError();
        }
        return result;
    }

    public static Throwable decodeToJMXException(Throwable ex) {
        Throwable jmxEx = ex;
        Throwable lastJmxEx = ex;
        while (jmxEx instanceof JMException || jmxEx instanceof JMRuntimeException) {
            lastJmxEx = jmxEx;
            if ((jmxEx = JMXExceptionDecoder.decode(jmxEx)) != lastJmxEx) continue;
            break;
        }
        return lastJmxEx;
    }

    public static void rethrow(Exception e) throws Exception {
        Throwable t = JMXExceptionDecoder.decode(e);
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw (Error)t;
    }
}

