/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.SerializationHelper;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayInfoImpl
extends ClassInfoImpl
implements ArrayInfo {
    private static final long serialVersionUID = 3905804162787980599L;
    protected TypeInfo componentType;
    protected int hash = -1;

    public ArrayInfoImpl() {
    }

    public ArrayInfoImpl(TypeInfo componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("Null component type.");
        }
        this.componentType = componentType;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        TypeInfo temp = componentType;
        while (temp.isArray()) {
            builder.append("[");
            temp = ((ArrayInfo)temp).getComponentType();
        }
        if (PrimitiveInfo.class.equals(temp.getClass())) {
            String encodedName = Signature.getPrimativeArrayType(temp.getName());
            builder.append(encodedName);
        } else {
            builder.append("L").append(temp.getName()).append(";");
        }
        this.name = builder.toString();
        this.calculateHash();
    }

    @Override
    @Deprecated
    public Class<? extends Object> getType() {
        if (this.annotatedElement == null) {
            try {
                TypeInfoFactory tif = SerializationHelper.getTypeInfoFactory();
                this.annotatedElement = tif.getTypeInfo(this.name, this.componentType.getType().getClassLoader()).getType();
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return (Class)this.annotatedElement;
    }

    @Override
    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return UNKNOWN_ANNOTATIONS;
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return this.componentType.equals(arrayInfo.getComponentType());
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = super.hashCode();
        this.hash = result = 29 * result + this.componentType.hashCode();
    }
}

