/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import javassist.CtClass;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistArrayInfoImpl
extends JavassistTypeInfo
implements ArrayInfo {
    private static final long serialVersionUID = 9195834689976459024L;
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    protected TypeInfo componentType;
    protected int hash = -1;

    private static String getName(TypeInfo componentType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        TypeInfo temp = componentType;
        while (temp.isArray()) {
            builder.append("[");
            temp = ((JavassistArrayInfoImpl)temp).componentType;
        }
        if (temp.isPrimitive()) {
            String encodedName = Signature.getPrimativeArrayType(temp.getName());
            builder.append(encodedName);
        } else {
            builder.append("L").append(temp.getName()).append(";");
        }
        return builder.toString();
    }

    JavassistArrayInfoImpl(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz, TypeInfo componentType) {
        super(factory, JavassistArrayInfoImpl.getName(componentType), ctClass, clazz);
        this.componentType = componentType;
        this.calculateHash();
    }

    @Override
    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return UNKNOWN_ANNOTATIONS;
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return this.componentType.equals(arrayInfo.getComponentType());
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = super.hashCode();
        this.hash = result = 29 * result + this.componentType.hashCode();
    }
}

