/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.plugins.SimpleProgressionConvertor;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.ProgressionConvertor;

public class ProgressionConvertorFactory {
    private static ProgressionConvertorFactory instance = new ProgressionConvertorFactory();
    private String convertorClassName = SimpleProgressionConvertor.class.getName();
    private ProgressionConvertor convertor;

    public static ProgressionConvertorFactory getInstance() {
        return instance;
    }

    public ProgressionConvertor getConvertor() throws Throwable {
        if (this.convertor == null) {
            ConvertorLookup lookup = new ConvertorLookup();
            this.convertor = AccessController.doPrivileged(lookup);
        }
        return this.convertor;
    }

    public void setConvertorClassName(String convertorClassName) {
        this.convertorClassName = convertorClassName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertorLookup
    implements PrivilegedExceptionAction<ProgressionConvertor> {
        private ConvertorLookup() {
        }

        @Override
        public ProgressionConvertor run() throws Exception {
            try {
                String convertorClass = System.getProperty("org.jboss.reflect.plugins.progressionConvertor", ProgressionConvertorFactory.this.convertorClassName);
                Object result = ReflectionUtils.newInstance(convertorClass);
                return (ProgressionConvertor)ProgressionConvertor.class.cast(result);
            }
            catch (Throwable t) {
                throw new Exception("Exception while creating convertor instance.", t);
            }
        }
    }
}

