/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshallLoaderConnector;
import org.jboss.remoting.marshal.MarshallerLoaderHandler;
import org.jboss.remoting.transport.Connector;

public class MarshallLoaderFactory {
    protected static final Logger log = Logger.getLogger(MarshallLoaderFactory.class);

    public static Connector createMarshallLoader(InvokerLocator locator) {
        MarshallLoaderConnector marshallerConnector;
        block4: {
            marshallerConnector = null;
            try {
                marshallerConnector = new MarshallLoaderConnector();
                marshallerConnector.setInvokerLocator(locator.getLocatorURI());
                marshallerConnector.start();
                MarshallerLoaderHandler loader = new MarshallerLoaderHandler();
                marshallerConnector.addInvocationHandler("loader", loader);
            }
            catch (Exception e) {
                log.error("Can not create marshaller loader.", e);
                if (marshallerConnector == null) break block4;
                try {
                    marshallerConnector.stop();
                    marshallerConnector.destroy();
                }
                catch (Exception e1) {
                    log.error("Error cleaning up marshaller loader connector.", e1);
                }
            }
        }
        return marshallerConnector;
    }

    public static InvokerLocator convertLocator(InvokerLocator locator) {
        String sPort;
        Map params;
        InvokerLocator loaderLocator = null;
        if (locator != null && (params = locator.getParameters()) != null && (sPort = (String)params.get("loaderport")) != null) {
            try {
                int port = Integer.parseInt(sPort);
                String transport = "socket";
                String host = locator.getHost();
                String path = locator.getPath();
                HashMap metadata = new HashMap();
                metadata.putAll(locator.getParameters());
                metadata.remove("loaderport");
                metadata.remove("marshaller");
                metadata.remove("unmarshaller");
                metadata.remove("datatype");
                metadata.remove("dataType");
                loaderLocator = new InvokerLocator(transport, host, port, path, metadata);
            }
            catch (NumberFormatException e) {
                log.error("Got loader port (" + sPort + ") from locator uri, but was not an number.");
            }
        }
        return loaderLocator;
    }
}

