/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.utility;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReadWriteArrayList
implements Serializable {
    private ArrayList arrayList;
    private static final long serialVersionUID = 6L;
    private Gate gate = new Gate();

    public ReadWriteArrayList() {
        this.arrayList = new ArrayList();
    }

    public boolean add(Object o) {
        this.gate.enterWrite();
        this.arrayList.add(o);
        this.gate.leaveWrite();
        return true;
    }

    public Object get(int i) {
        this.gate.enterRead(i);
        Object o = this.arrayList.get(i);
        this.gate.leaveRead();
        return o;
    }

    public ArrayList copy() {
        return (ArrayList)this.subList(0, this.arrayList.size());
    }

    public List subList(int from, int to) {
        this.gate.enterRead(to - 1);
        ArrayList list2 = new ArrayList(this.arrayList.subList(from, to));
        this.gate.leaveRead();
        return list2;
    }

    public Object firstElement() {
        return this.get(0);
    }

    public Object remove(int i) {
        this.gate.enterRead(i);
        Object o = this.arrayList.remove(i);
        this.gate.leaveRead();
        return o;
    }

    public int size() {
        return this.arrayList.size();
    }

    public Object[] toArray() {
        return this.arrayList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.arrayList.toArray(a);
    }

    public ArrayList toArrayList() {
        return this.arrayList;
    }

    class Gate
    implements Serializable {
        private static final long serialVersionUID = 7L;
        private int numberOfReaders;
        private int numberOfWriters;

        Gate() {
        }

        public synchronized void enterRead(int i) {
            while (this.numberOfWriters > 0 || i > ReadWriteArrayList.this.arrayList.size() - 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.numberOfReaders;
        }

        public synchronized void enterWrite() {
            while (this.numberOfWriters > 0 || this.numberOfReaders > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.numberOfWriters;
        }

        public synchronized void leaveRead() {
            if (this.numberOfReaders <= 0) {
                throw new Error("number of readers <= 0");
            }
            --this.numberOfReaders;
            this.notifyAll();
        }

        public synchronized void leaveWrite() {
            if (this.numberOfWriters <= 0) {
                throw new Error("number of writers <= 0");
            }
            --this.numberOfWriters;
            this.notifyAll();
        }
    }
}

