/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
import org.jboss.resource.adapter.jdbc.CheckValidConnectionSQL;
import org.jboss.resource.adapter.jdbc.ExceptionSorter;
import org.jboss.resource.adapter.jdbc.NullExceptionSorter;
import org.jboss.resource.adapter.jdbc.NullStaleConnectionChecker;
import org.jboss.resource.adapter.jdbc.NullValidConnectionChecker;
import org.jboss.resource.adapter.jdbc.StaleConnectionChecker;
import org.jboss.resource.adapter.jdbc.URLSelectorStrategy;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
import org.jboss.resource.adapter.jdbc.WrappedConnectionRequestInfo;
import org.jboss.resource.adapter.jdbc.WrapperDataSource;

public abstract class BaseWrapperManagedConnectionFactory
implements ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
Serializable {
    static final long serialVersionUID = -84923705377702088L;
    public static final int TRACK_STATEMENTS_FALSE_INT = 0;
    public static final int TRACK_STATEMENTS_TRUE_INT = 1;
    public static final int TRACK_STATEMENTS_NOWARN_INT = 2;
    public static final String TRACK_STATEMENTS_FALSE = "false";
    public static final String TRACK_STATEMENTS_TRUE = "true";
    public static final String TRACK_STATEMENTS_NOWARN = "nowarn";
    protected final Logger log = Logger.getLogger(this.getClass());
    protected String userName;
    protected String password;
    protected final Properties connectionProps = new Properties();
    protected int transactionIsolation = -1;
    protected int preparedStatementCacheSize = 0;
    protected boolean doQueryTimeout = false;
    protected String newConnectionSQL;
    protected String checkValidConnectionSQL;
    protected String validConnectionCheckerClassName;
    protected ValidConnectionChecker connectionChecker;
    protected StaleConnectionChecker staleConnectionChecker;
    private String staleConnectionCheckerClassName;
    private String exceptionSorterClassName;
    private ExceptionSorter exceptionSorter;
    protected int trackStatements = 2;
    protected boolean sharePS = false;
    protected boolean isTransactionQueryTimeout = false;
    protected int queryTimeout = 0;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClassName;
    private URLSelectorStrategy urlSelectorStrategy;
    private boolean validateOnMatch = true;

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new WrapperDataSource(this, cm);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new JBossResourceException("Resource Adapter does not currently support running in a non-managed environment.");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int size) {
        this.preparedStatementCacheSize = size;
    }

    public boolean getSharePreparedStatements() {
        return this.sharePS;
    }

    public void setSharePreparedStatements(boolean sharePS) {
        this.sharePS = sharePS;
    }

    public String getTransactionIsolation() {
        switch (this.transactionIsolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case -1: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.transactionIsolation);
    }

    public void setTransactionIsolation(String transactionIsolation) {
        if (transactionIsolation.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (transactionIsolation.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (transactionIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (transactionIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (transactionIsolation.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            try {
                this.transactionIsolation = Integer.parseInt(transactionIsolation);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Setting Isolation level to unknown state: " + transactionIsolation);
            }
        }
    }

    public String getNewConnectionSQL() {
        return this.newConnectionSQL;
    }

    public void setNewConnectionSQL(String newConnectionSQL) {
        this.newConnectionSQL = newConnectionSQL;
    }

    public String getCheckValidConnectionSQL() {
        return this.checkValidConnectionSQL;
    }

    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.checkValidConnectionSQL = checkValidConnectionSQL;
    }

    public void setStaleConnectionCheckerClassName(String value) {
        this.staleConnectionCheckerClassName = value;
    }

    public String getStaleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public String getTrackStatements() {
        if (this.trackStatements == 0) {
            return TRACK_STATEMENTS_FALSE;
        }
        if (this.trackStatements == 1) {
            return TRACK_STATEMENTS_TRUE;
        }
        return TRACK_STATEMENTS_NOWARN;
    }

    public boolean getValidateOnMatch() {
        return this.validateOnMatch;
    }

    public void setValidateOnMatch(boolean validateOnMatch) {
        this.validateOnMatch = validateOnMatch;
    }

    public void setTrackStatements(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value for trackStatements");
        }
        String trimmed = value.trim();
        this.trackStatements = trimmed.equalsIgnoreCase(TRACK_STATEMENTS_FALSE) ? 0 : (trimmed.equalsIgnoreCase(TRACK_STATEMENTS_TRUE) ? 1 : 2);
    }

    public String getExceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.exceptionSorterClassName = exceptionSorterClassName;
    }

    public String getValidConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public void setValidConnectionCheckerClassName(String value) {
        this.validConnectionCheckerClassName = value;
    }

    public boolean isTransactionQueryTimeout() {
        return this.isTransactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(boolean value) {
        this.isTransactionQueryTimeout = value;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
    }

    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimiter) throws ResourceException {
        this.urlDelimiter = urlDelimiter;
    }

    public void setUrlSelectorStrategyClassName(String urlSelectorStrategyClassName) {
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
    }

    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public URLSelectorStrategy getUrlSelectorStrategy() {
        return this.urlSelectorStrategy;
    }

    public Object loadClass(String className, Object constructorParameter) {
        Object result = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            Class[] param = new Class[]{List.class};
            Constructor<?> cnstructor = clazz.getDeclaredConstructor(param);
            Object[] consParameter = new Object[]{constructorParameter};
            result = cnstructor.newInstance(consParameter);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error("Class not found for URLSelectStrategy :" + className);
        }
        catch (InstantiationException ie) {
            this.log.error("Could not instantiate URLSelectorStrategy type :" + className);
        }
        catch (IllegalAccessException iae) {
            this.log.error("Check for the constructor with List parameter for URLSelectStrategy class as " + className);
        }
        catch (InvocationTargetException ite) {
            this.log.error("Constructor Invocation failing for URLSelectorStrategy " + className);
        }
        catch (NoSuchMethodException nsme) {
            this.log.error("Constructor or Method mismatch in URLSelectorStrategy :" + className);
        }
        return result;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        HashSet<BaseWrapperManagedConnection> invalid = new HashSet<BaseWrapperManagedConnection>();
        for (Object anonymous : connectionSet) {
            BaseWrapperManagedConnection mc;
            if (!(anonymous instanceof BaseWrapperManagedConnection) || (mc = (BaseWrapperManagedConnection)anonymous).checkValid()) continue;
            invalid.add(mc);
        }
        return invalid;
    }

    protected Properties getConnectionProperties(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri != null && cri.getClass() != WrappedConnectionRequestInfo.class) {
            throw new JBossResourceException("Wrong kind of ConnectionRequestInfo: " + cri.getClass());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionProps);
        if (subject != null) {
            if (SubjectActions.addMatchingProperties(subject, props, this)) {
                return props;
            }
            throw new JBossResourceException("No matching credentials in Subject!");
        }
        WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)cri;
        if (lcri != null) {
            props.setProperty("user", lcri.getUserName() == null ? "" : lcri.getUserName());
            props.setProperty("password", lcri.getPassword() == null ? "" : lcri.getPassword());
            return props;
        }
        if (this.userName != null) {
            props.setProperty("user", this.userName);
            props.setProperty("password", this.password == null ? "" : this.password);
        }
        return props;
    }

    boolean isExceptionFatal(SQLException e) {
        try {
            if (this.exceptionSorter != null) {
                return this.exceptionSorter.isExceptionFatal(e);
            }
            if (this.exceptionSorterClassName != null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = cl.loadClass(this.exceptionSorterClassName);
                    this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
                    return this.exceptionSorter.isExceptionFatal(e);
                }
                catch (Exception e2) {
                    this.log.warn("exception trying to create exception sorter (disabling):", e2);
                    this.exceptionSorter = new NullExceptionSorter();
                }
            }
        }
        catch (Throwable t) {
            this.log.warn("Error checking exception fatality: ", t);
        }
        return false;
    }

    SQLException isValidConnection(Connection c) {
        if (this.connectionChecker != null) {
            return this.connectionChecker.isValidConnection(c);
        }
        if (this.validConnectionCheckerClassName != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = cl.loadClass(this.validConnectionCheckerClassName);
                this.connectionChecker = (ValidConnectionChecker)clazz.newInstance();
                return this.connectionChecker.isValidConnection(c);
            }
            catch (Exception e) {
                this.log.warn("Exception trying to create connection checker (disabling):", e);
                this.connectionChecker = new NullValidConnectionChecker();
            }
        }
        if (this.checkValidConnectionSQL != null) {
            this.connectionChecker = new CheckValidConnectionSQL(this.checkValidConnectionSQL);
            return this.connectionChecker.isValidConnection(c);
        }
        return null;
    }

    boolean isStaleConnection(SQLException e) {
        boolean isStale = false;
        if (this.staleConnectionChecker != null) {
            isStale = this.staleConnectionChecker.isStaleConnection(e);
        }
        if (this.staleConnectionCheckerClassName != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = cl.loadClass(this.staleConnectionCheckerClassName);
                this.staleConnectionChecker = (StaleConnectionChecker)clazz.newInstance();
                isStale = this.staleConnectionChecker.isStaleConnection(e);
            }
            catch (Exception ex2) {
                this.log.warn("exception trying to create stale connection checker (disabling)" + this.staleConnectionCheckerClassName, ex2);
                this.staleConnectionChecker = new NullStaleConnectionChecker();
            }
        }
        return isStale;
    }

    static class SubjectActions
    implements PrivilegedAction {
        Subject subject;
        Properties props;
        ManagedConnectionFactory mcf;

        SubjectActions(Subject subject, Properties props, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.props = props;
            this.mcf = mcf;
        }

        public Object run() {
            for (Object o : this.subject.getPrivateCredentials()) {
                PasswordCredential cred;
                if (!(o instanceof PasswordCredential) || !((Object)(cred = (PasswordCredential)o).getManagedConnectionFactory()).equals(this.mcf)) continue;
                this.props.setProperty("user", cred.getUserName() == null ? "" : cred.getUserName());
                if (cred.getPassword() != null) {
                    this.props.setProperty("password", new String(cred.getPassword()));
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        static boolean addMatchingProperties(Subject subject, Properties props, ManagedConnectionFactory mcf) {
            SubjectActions action = new SubjectActions(subject, props, mcf);
            Boolean matched = (Boolean)AccessController.doPrivileged(action);
            return matched;
        }
    }
}

