/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.deployment.DeploymentException;
import org.jboss.resource.deployment.AdminObjectFactory;
import org.jboss.resource.deployment.AdminObjectMBean;
import org.jboss.resource.metadata.AdminObjectMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.Util;

public class AdminObject
extends ServiceMBeanSupport
implements AdminObjectMBean {
    protected ObjectName rarName;
    protected String type;
    protected Properties properties;
    protected String jndiName;

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ObjectName getRARName() {
        return this.rarName;
    }

    public void setRARName(ObjectName rarName) {
        this.rarName = rarName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void startService() throws Exception {
        AdminObjectMetaData aomd = this.retrieveAdminObjectMetaData();
        if (aomd == null) {
            throw new DeploymentException("No admin object metadata type=" + this.type + " ra=" + this.rarName);
        }
        Object adminObject = this.createAdminObject(aomd);
        this.bind(adminObject);
    }

    protected void stopService() throws Exception {
        this.unbind();
    }

    protected AdminObjectMetaData retrieveAdminObjectMetaData() throws DeploymentException {
        try {
            ConnectorMetaData cmd = (ConnectorMetaData)this.server.getAttribute(this.rarName, "MetaData");
            return cmd.getAdminObject(this.type);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error retrieving admin object metadata type=" + this.type + " ra=" + this.rarName, t);
            return null;
        }
    }

    protected Object createAdminObject(AdminObjectMetaData aomd) throws DeploymentException {
        try {
            return AdminObjectFactory.createAdminObject(this.jndiName, this.rarName, aomd, this.properties);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error creating admin object metadata type=" + this.type + " ra=" + this.rarName, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(Object object) throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            Util.bind((Context)ctx, this.jndiName, object);
            this.log.info("Bound admin object '" + object.getClass().getName() + "' at '" + this.jndiName + "'");
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbind() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            Util.unbind((Context)ctx, this.jndiName);
            this.log.info("Unbound admin object at '" + this.jndiName + "'");
        }
        finally {
            ctx.close();
        }
    }
}

