/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AppConfigurationEntryHolder;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.xb.binding.GenericValueContainer;

public class AuthenticationInfoContainer
implements GenericValueContainer {
    private static Logger log = Logger.getLogger(AuthenticationInfoContainer.class);
    BaseAuthenticationInfo info = null;
    String authName = null;
    List moduleEntries = new ArrayList();
    Map loginModuleStackMap = new HashMap();
    boolean isJASPIAuthentication = false;

    public void addChild(QName name, Object value) {
        log.debug("addChild::" + name + ":" + value);
        if ("name".equals(name.getLocalPart())) {
            this.authName = (String)value;
        } else if (value instanceof AppConfigurationEntryHolder) {
            AppConfigurationEntryHolder ace = (AppConfigurationEntryHolder)value;
            this.moduleEntries.add(ace.getEntry());
        } else if (value instanceof AppConfigurationEntry) {
            AppConfigurationEntry ace = (AppConfigurationEntry)value;
            this.moduleEntries.add(ace);
        } else if (value instanceof AuthModuleEntry) {
            AuthModuleEntry ame = (AuthModuleEntry)value;
            String lmshName = ame.getLoginModuleStackHolderName();
            if (lmshName != null) {
                ame.setLoginModuleStackHolder((LoginModuleStackHolder)this.loginModuleStackMap.get(lmshName));
            }
            this.moduleEntries.add(ame);
            this.isJASPIAuthentication = true;
        } else if (value instanceof LoginModuleStackHolder) {
            LoginModuleStackHolder lmsh = (LoginModuleStackHolder)value;
            this.loginModuleStackMap.put(lmsh.getName(), lmsh);
        }
    }

    public Object instantiate() {
        this.info = !this.isJASPIAuthentication ? new AuthenticationInfo(this.authName) : new JASPIAuthenticationInfo(this.authName);
        this.info.add(this.moduleEntries);
        return this.info;
    }

    public Class getTargetClass() {
        return BaseAuthenticationInfo.class;
    }
}

