/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.DecodeAction;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class LdapLoginModule
extends UsernamePasswordLoginModule {
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = true;
                String flag = (String)this.options.get("allowEmptyPasswords");
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    this.log.trace("Rejecting empty password due to allowEmptyPasswords");
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                this.createLdapInitContext(username, inputPassword);
                isValid = true;
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    private void createLdapInitContext(String username, Object credential) throws Exception {
        InitialLdapContext ctx;
        block38: {
            String principalDNSuffix;
            String principalDNPrefix;
            String authType;
            boolean trace = this.log.isTraceEnabled();
            Properties env = new Properties();
            for (Map.Entry entry : this.options.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
            String factoryName = env.getProperty("java.naming.factory.initial");
            if (factoryName == null) {
                factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
                env.setProperty("java.naming.factory.initial", factoryName);
            }
            if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
                env.setProperty("java.naming.security.authentication", "simple");
            }
            String protocol = env.getProperty("java.naming.security.protocol");
            String providerURL = (String)this.options.get("java.naming.provider.url");
            if (providerURL == null) {
                providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            }
            String bindDN = (String)this.options.get("java.naming.security.principal");
            String bindCredential = (String)this.options.get("java.naming.security.credentials");
            String securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT);
            if (securityDomain != null) {
                ObjectName serviceName = new ObjectName(securityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            if ((principalDNPrefix = (String)this.options.get(PRINCIPAL_DN_PREFIX_OPT)) == null) {
                principalDNPrefix = "";
            }
            if ((principalDNSuffix = (String)this.options.get(PRINCIPAL_DN_SUFFIX_OPT)) == null) {
                principalDNSuffix = "";
            }
            String matchType = (String)this.options.get(MATCH_ON_USER_DN_OPT);
            boolean matchOnUserDN = Boolean.valueOf(matchType);
            String userDN = principalDNPrefix + username + principalDNSuffix;
            env.setProperty("java.naming.provider.url", providerURL);
            env.setProperty("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", credential);
            if (trace) {
                Properties tmp = new Properties();
                tmp.putAll((Map<?, ?>)env);
                tmp.setProperty("java.naming.security.credentials", "***");
                this.log.trace("Logging into LDAP server, env=" + tmp.toString());
            }
            ctx = new InitialLdapContext(env, null);
            if (trace) {
                this.log.trace("Logged into LDAP server, " + ctx);
            }
            if (bindDN != null) {
                if (trace) {
                    this.log.trace("Rebind SECURITY_PRINCIPAL to: " + bindDN);
                }
                env.setProperty("java.naming.security.principal", bindDN);
                env.put("java.naming.security.credentials", bindCredential);
                ctx = new InitialLdapContext(env, null);
            }
            String rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
            String userRolesCtxDNAttributeName = (String)this.options.get(USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT);
            if (userRolesCtxDNAttributeName != null) {
                String[] returnAttribute = new String[]{userRolesCtxDNAttributeName};
                try {
                    Attributes result = ctx.getAttributes(userDN, returnAttribute);
                    if (result.get(userRolesCtxDNAttributeName) != null) {
                        rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
                        this.log.trace("Found user roles context DN: " + rolesCtxDN);
                    }
                }
                catch (NamingException e) {
                    this.log.debug("Failed to query userRolesCtxDNAttributeName", e);
                }
            }
            if (rolesCtxDN != null) {
                String scope;
                String roleAttrName;
                String uidAttrName = (String)this.options.get(UID_ATTRIBUTE_ID_OPT);
                if (uidAttrName == null) {
                    uidAttrName = "uid";
                }
                if ((roleAttrName = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT)) == null) {
                    roleAttrName = "roles";
                }
                StringBuffer roleFilter = new StringBuffer("(");
                roleFilter.append(uidAttrName);
                roleFilter.append("={0})");
                String userToMatch = username;
                if (matchOnUserDN) {
                    userToMatch = userDN;
                }
                String[] roleAttr = new String[]{roleAttrName};
                String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
                boolean roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
                String roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
                if (roleNameAttributeID == null) {
                    roleNameAttributeID = "name";
                }
                int searchScope = 2;
                int searchTimeLimit = 10000;
                String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
                if (timeLimit != null) {
                    try {
                        searchTimeLimit = Integer.parseInt(timeLimit);
                    }
                    catch (NumberFormatException e) {
                        this.log.trace("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + searchTimeLimit);
                    }
                }
                if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
                    searchScope = 0;
                } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 1;
                }
                if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 2;
                }
                try {
                    SearchControls controls = new SearchControls();
                    controls.setSearchScope(searchScope);
                    controls.setReturningAttributes(roleAttr);
                    controls.setTimeLimit(searchTimeLimit);
                    Object[] filterArgs = new Object[]{userToMatch};
                    if (trace) {
                        this.log.trace("searching rolesCtxDN=" + rolesCtxDN + ", roleFilter=" + roleFilter + ", filterArgs=" + userToMatch + ", roleAttr=" + roleAttr + ", searchScope=" + searchScope + ", searchTimeLimit=" + searchTimeLimit);
                    }
                    NamingEnumeration<SearchResult> answer = ctx.search(rolesCtxDN, roleFilter.toString(), filterArgs, controls);
                    while (answer.hasMore()) {
                        SearchResult sr = answer.next();
                        if (trace) {
                            this.log.trace("Checking answer: " + sr.getName());
                        }
                        Attributes attrs = sr.getAttributes();
                        Attribute roles = attrs.get(roleAttrName);
                        for (int r = 0; r < roles.size(); ++r) {
                            Object value = roles.get(r);
                            String roleName = null;
                            if (roleAttributeIsDN) {
                                String roleDN = value.toString();
                                String[] returnAttribute = new String[]{roleNameAttributeID};
                                if (trace) {
                                    this.log.trace("Following roleDN: " + roleDN);
                                }
                                try {
                                    Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
                                    Attribute roles2 = result2.get(roleNameAttributeID);
                                    if (roles2 == null) continue;
                                    for (int m = 0; m < roles2.size(); ++m) {
                                        roleName = (String)roles2.get(m);
                                        this.addRole(roleName);
                                    }
                                    continue;
                                }
                                catch (NamingException e) {
                                    this.log.trace("Failed to query roleNameAttrName", e);
                                    continue;
                                }
                            }
                            roleName = value.toString();
                            this.addRole(roleName);
                        }
                    }
                    answer.close();
                }
                catch (NamingException e) {
                    if (!trace) break block38;
                    this.log.trace("Failed to locate roles", e);
                }
            }
        }
        ctx.close();
    }

    private void addRole(String roleName) {
        if (roleName != null) {
            try {
                Principal p = super.createIdentity(roleName);
                this.log.trace("Assign user to role " + roleName);
                this.userRoles.addMember(p);
            }
            catch (Exception e) {
                this.log.debug("Failed to create principal: " + roleName, e);
            }
        }
    }
}

