/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.net.URL;
import java.security.Policy;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.jacc.DelegatingPolicy;
import org.jboss.security.jacc.JBossPolicyConfiguration;
import org.jboss.security.jacc.SecurityActions;
import org.jboss.util.state.StateMachine;
import org.jboss.util.state.xml.StateMachineParser;

public class JBossPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private StateMachine configStateMachine;
    private ConcurrentHashMap policyConfigMap = new ConcurrentHashMap();
    private DelegatingPolicy policy;

    public JBossPolicyConfigurationFactory() {
        try {
            ClassLoader loader = SecurityActions.getContextClassloader();
            URL states = SecurityActions.getResource(loader, "org/jboss/security/jacc/jacc-policy-config-states.xml");
            StateMachineParser smp = new StateMachineParser();
            this.configStateMachine = smp.parse(states);
        }
        catch (Exception e) {
            IllegalStateException ex = new IllegalStateException("Failed to parse jacc-policy-config-states.xml", e);
            ex.initCause(e);
            throw ex;
        }
        Policy p = SecurityActions.getPolicy();
        if (!(p instanceof DelegatingPolicy)) {
            p = DelegatingPolicy.getInstance();
        }
        this.policy = (DelegatingPolicy)p;
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get(contextID);
        if (pc == null) {
            StateMachine sm = (StateMachine)this.configStateMachine.clone();
            pc = new JBossPolicyConfiguration(contextID, this.policy, sm);
            this.policyConfigMap.put(contextID, pc);
        }
        pc.initPolicyConfiguration(remove);
        return pc;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        boolean inService = false;
        JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get(contextID);
        if (pc != null) {
            inService = pc.inService();
        }
        return inService;
    }
}

