/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jndi;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;

class SecurityAssociationActions {
    SecurityAssociationActions() {
    }

    static void setPrincipalInfo(Principal principal, Object credential) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential);
        AccessController.doPrivileged(action);
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoStackAction action = new SetPrincipalInfoStackAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void popPrincipalInfo() {
        PopPrincipalInfoAction action = new PopPrincipalInfoAction();
        AccessController.doPrivileged(action);
    }

    static void setServer() {
        AccessController.doPrivileged(SetServerAction.ACTION);
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    private static class SetServerAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new SetServerAction();

        private SetServerAction() {
        }

        public Object run() {
            SecurityAssociation.setServer();
            return null;
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    private static class PopPrincipalInfoAction
    implements PrivilegedAction {
        private PopPrincipalInfoAction() {
        }

        public Object run() {
            SecurityAssociation.popSubjectContext();
            return null;
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;

        SetPrincipalInfoAction(Principal principal, Object credential) {
            this.principal = principal;
            this.credential = credential;
        }

        public Object run() {
            SecurityAssociation.setCredential(this.credential);
            this.credential = null;
            SecurityAssociation.setPrincipal(this.principal);
            this.principal = null;
            return null;
        }
    }

    private static class SetPrincipalInfoStackAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoStackAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityAssociation.pushSubjectContext(this.subject, this.principal, this.credential);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

