/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.FieldsContainer;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.RegularObjectPersister;

public class ObjectOutputStreamProxy
extends ObjectOutputStream {
    Object currentObj;
    ClassMetaDataSlot currentMetaClass;
    ObjectSubstitutionInterface currentSubstitution;
    FieldsContainer currentContainer = null;
    ObjectOutput bout;

    public ObjectOutputStreamProxy(ObjectOutput output, Object currentObj, ClassMetaDataSlot currentMetaClass, ObjectSubstitutionInterface currentSubstitution) throws IOException {
        this.bout = output;
        this.currentObj = currentObj;
        this.currentMetaClass = currentMetaClass;
        this.currentSubstitution = currentSubstitution;
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        this.bout.writeObject(obj);
    }

    public void writeUnshared(Object obj) throws IOException {
        this.writeObjectOverride(obj);
    }

    public void defaultWriteObject() throws IOException {
        this.writeFields();
    }

    public void writeFields() throws IOException {
        if (this.currentContainer != null) {
            this.currentContainer.writeMyself(this);
            this.currentContainer = null;
        } else {
            RegularObjectPersister.writeSlotWithFields(this.currentMetaClass, this.bout, this.currentObj, this.currentSubstitution);
        }
    }

    public void reset() throws IOException {
    }

    protected void writeStreamHeader() throws IOException {
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
    }

    public void write(int val) throws IOException {
        this.bout.write(val);
    }

    public void write(byte[] buf) throws IOException {
        this.bout.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new SerializationException("buf can't be null");
        }
        this.bout.write(buf, off, len);
    }

    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this.bout.close();
    }

    public void writeBoolean(boolean val) throws IOException {
        this.bout.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.bout.writeByte(val);
    }

    public void writeShort(int val) throws IOException {
        this.bout.writeShort(val);
    }

    public void writeChar(int val) throws IOException {
        this.bout.writeChar(val);
    }

    public void writeInt(int val) throws IOException {
        this.bout.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.bout.writeLong(val);
    }

    public void writeFloat(float val) throws IOException {
        this.bout.writeFloat(val);
    }

    public void writeDouble(double val) throws IOException {
        this.bout.writeDouble(val);
    }

    public void writeBytes(String str) throws IOException {
        this.bout.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        this.bout.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        this.bout.writeUTF(str);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        this.currentContainer = new FieldsContainer(this.currentMetaClass);
        return this.currentContainer.createPut();
    }
}

