/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import org.jboss.deployment.DeploymentException;
import org.jboss.system.metadata.ServiceElementValueMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceJavaBeanValueMetaData
extends ServiceElementValueMetaData {
    private static final long serialVersionUID = 1L;

    public ServiceJavaBeanValueMetaData() {
    }

    public ServiceJavaBeanValueMetaData(Element element) {
        super(element);
    }

    public Object getValue(ServiceValueContext valueContext) throws Exception {
        MBeanAttributeInfo attributeInfo = valueContext.getAttributeInfo();
        ClassLoader cl = valueContext.getClassloader();
        boolean trim = valueContext.isTrim();
        boolean replace = valueContext.isReplace();
        Element element = this.getElement();
        String attributeClassName = element.getAttribute("attributeClass");
        if (attributeClassName == null || attributeClassName.length() == 0) {
            attributeClassName = attributeInfo.getType();
        }
        if (attributeClassName == null) {
            throw new DeploymentException("AttributeInfo for " + attributeInfo.getName() + " has no type");
        }
        Class<?> attributeClass = cl.loadClass(attributeClassName);
        Object bean = attributeClass.newInstance();
        NodeList properties = element.getElementsByTagName("property");
        Properties beanProps = new Properties();
        for (int n = 0; n < properties.getLength(); ++n) {
            Node node = properties.item(n);
            if (node.getNodeType() != 1) continue;
            Element property = (Element)node;
            String name = property.getAttribute("name");
            String value = ServiceMetaDataParser.getElementTextContent(property, trim, replace);
            beanProps.setProperty(name, value);
        }
        PropertyEditors.mapJavaBeanProperties(bean, beanProps);
        return bean;
    }
}

