/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;

public class TransactionPropagationContextUtil {
    private static TransactionPropagationContextFactory tpcFactory;
    private static TransactionPropagationContextImporter tpcImporter;
    private static final String EXPORTER_JNDI_NAME = "java:/TransactionPropagationContextExporter";
    private static final String IMPORTER_JNDI_NAME = "java:/TransactionPropagationContextImporter";

    public static TransactionPropagationContextFactory getTPCFactoryClientSide() {
        return tpcFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionPropagationContextFactory getTPCFactory() {
        if (tpcFactory == null) {
            try {
                InitialContext ctx = new InitialContext();
                try {
                    tpcFactory = (TransactionPropagationContextFactory)ctx.lookup(EXPORTER_JNDI_NAME);
                }
                finally {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to lookup java:/TransactionPropagationContextExporter", e);
            }
        }
        return tpcFactory;
    }

    public static void setTPCFactory(TransactionPropagationContextFactory tpcFactory) {
        TransactionPropagationContextUtil.tpcFactory = tpcFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionPropagationContextImporter getTPCImporter() {
        if (tpcImporter == null) {
            try {
                InitialContext ctx = new InitialContext();
                try {
                    tpcImporter = (TransactionPropagationContextImporter)ctx.lookup(IMPORTER_JNDI_NAME);
                }
                finally {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to look up java:/TransactionPropagationContextImporter", e);
            }
        }
        return tpcImporter;
    }

    public static void setTPCImporter(TransactionPropagationContextImporter importer) {
        tpcImporter = importer;
    }

    public static Transaction importTPC(Object tpc) {
        return TransactionPropagationContextUtil.getTPCImporter().importTransactionPropagationContext(tpc);
    }
}

