/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jboss.logging.Logger;
import org.jboss.util.NullArgumentException;
import org.jboss.util.platform.Java;

public interface NestedThrowable
extends Serializable {
    public static final boolean PARENT_TRACE_ENABLED = Util.getBoolean("parentTraceEnabled", true);
    public static final boolean NESTED_TRACE_ENABLED = Util.getBoolean("nestedTraceEnabled", Java.isCompatible(5) && !PARENT_TRACE_ENABLED || !Java.isCompatible(5));
    public static final boolean DETECT_DUPLICATE_NESTING = Util.getBoolean("detectDuplicateNesting", true);

    public Throwable getNested();

    public Throwable getCause();

    public static final class Util {
        private static Logger log = Logger.getLogger(NestedThrowable.class);

        private static Logger getLogger() {
            if (log == null) {
                log = Logger.getLogger(NestedThrowable.class);
            }
            return log;
        }

        protected static boolean getBoolean(String name, boolean defaultValue) {
            name = NestedThrowable.class.getName() + "." + name;
            String value = System.getProperty(name, String.valueOf(defaultValue));
            log = Util.getLogger();
            log.debug(name + "=" + value);
            return new Boolean(value);
        }

        public static void checkNested(NestedThrowable parent, Throwable child) {
            Class<?> childType;
            if (!DETECT_DUPLICATE_NESTING || parent == null || child == null) {
                return;
            }
            Class<?> parentType = parent.getClass();
            if (parentType.isAssignableFrom(childType = child.getClass())) {
                log = Util.getLogger();
                log.warn("Duplicate throwable nesting of same base type: " + parentType + " is assignable from: " + childType);
            }
        }

        public static String getMessage(String msg, Throwable nested) {
            StringBuffer buff = new StringBuffer(msg == null ? "" : msg);
            if (nested != null) {
                buff.append(msg == null ? "- " : "; - ").append("nested throwable: (").append(nested).append(")");
            }
            return buff.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void print(Throwable nested, PrintStream stream) {
            if (stream == null) {
                throw new NullArgumentException("stream");
            }
            if (NESTED_TRACE_ENABLED && nested != null) {
                PrintStream printStream = stream;
                synchronized (printStream) {
                    if (PARENT_TRACE_ENABLED) {
                        stream.print(" + nested throwable: ");
                    } else {
                        stream.print("[ parent trace omitted ]: ");
                    }
                    nested.printStackTrace(stream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void print(Throwable nested, PrintWriter writer) {
            if (writer == null) {
                throw new NullArgumentException("writer");
            }
            if (NESTED_TRACE_ENABLED && nested != null) {
                PrintWriter printWriter = writer;
                synchronized (printWriter) {
                    if (PARENT_TRACE_ENABLED) {
                        writer.print(" + nested throwable: ");
                    } else {
                        writer.print("[ parent trace omitted ]: ");
                    }
                    nested.printStackTrace(writer);
                }
            }
        }
    }
}

