/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.util.NullArgumentException;

public class ListSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    protected final List list;

    public ListSet(List list2) {
        if (list2 == null) {
            throw new NullArgumentException("list");
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list2.get(i);
            if (list2.indexOf(obj) == list2.lastIndexOf(obj)) continue;
            throw new IllegalArgumentException("list contains duplicate entries");
        }
        this.list = list2;
    }

    public ListSet() {
        this(new ArrayList());
    }

    public ListSet(Collection elements) {
        this(new ArrayList(elements));
    }

    public List getList() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public boolean add(Object obj) {
        boolean added = false;
        if (!this.list.contains(obj)) {
            added = this.list.add(obj);
        }
        return added;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    public boolean remove(Object obj) {
        return this.list.remove(obj);
    }

    public void clear() {
        this.list.clear();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

