/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.metadata.config.EndpointProperty;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonConfig {
    private String configName;
    private List<URI> features = new ArrayList<URI>();
    private List<EndpointProperty> properties = new ArrayList<EndpointProperty>();

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public abstract List<HandlerMetaData> getHandlers(EndpointMetaData var1, UnifiedHandlerMetaData.HandlerType var2);

    public boolean hasFeature(URI type) {
        return this.features.contains(type);
    }

    public boolean hasFeature(String uri) {
        return this.hasFeature(CommonConfig.nameToURI(uri));
    }

    public void setFeature(String type, boolean enabled) {
        if (enabled) {
            this.features.add(CommonConfig.nameToURI(type));
        } else {
            this.features.remove(CommonConfig.nameToURI(type));
        }
    }

    public void addProperty(String name, String value) {
        EndpointProperty p = new EndpointProperty();
        p.name = CommonConfig.nameToURI(name);
        p.value = value;
        this.properties.add(p);
    }

    public String getProperty(String name) {
        String value = null;
        URI uri = CommonConfig.nameToURI(name);
        for (EndpointProperty wsp : this.properties) {
            if (!wsp.name.equals(uri)) continue;
            value = wsp.value;
            break;
        }
        return value;
    }

    public List<EndpointProperty> getProperties() {
        return this.properties;
    }

    private static URI nameToURI(String name) {
        URI uri = null;
        try {
            uri = new URI(name);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return uri;
    }
}

