/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.jboss.logging.Logger;

public class JBossXSErrorHandler
implements XMLErrorHandler {
    private static final Logger log = Logger.getLogger(JBossXSErrorHandler.class);

    public void warning(String domain, String key, XMLParseException xexp) throws XNIException {
        log.trace(this.getFormattedString(domain, key, xexp));
    }

    public void error(String domain, String key, XMLParseException xexp) throws XNIException {
        if ("src-include.2.1".equals(key)) {
            throw new XNIException("Parser should stop:", (Exception)xexp);
        }
        String errorMsg = this.getFormattedString(domain, key, xexp);
        log.error(errorMsg);
    }

    public void fatalError(String domain, String key, XMLParseException xexp) throws XNIException {
        String errorMsg = this.getFormattedString(domain, key, xexp);
        log.error(errorMsg);
        throw new XNIException("Parser should stop: " + errorMsg, (Exception)xexp);
    }

    private String getFileName(XMLParseException xexp) {
        String fname = xexp.getExpandedSystemId();
        if (fname != null) {
            int index = fname.lastIndexOf(47);
            if (index != -1) {
                fname = fname.substring(index + 1);
            }
        } else {
            fname = "";
        }
        return fname;
    }

    private String getFormattedString(String domain, String key, XMLParseException xexp) {
        StringBuilder buf = new StringBuilder(this.getFileName(xexp));
        buf.append("[domain:");
        buf.append(domain).append("]::[key=").append(key).append("]::");
        buf.append("Message=");
        buf.append(xexp.getLocalizedMessage());
        return buf.toString();
    }
}

