/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class WebservicesFactory
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger(WebservicesFactory.class);
    private URL descriptorURL;

    public WebservicesFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public static WebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        WebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = null;
        try {
            wsdd = root.findChild("META-INF/webservices.xml");
        }
        catch (IOException e) {
            // empty catch block
        }
        if (null == wsdd) {
            try {
                wsdd = root.findChild("WEB-INF/webservices.xml");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (wsdd != null) {
            URL wsddUrl = wsdd.toURL();
            try {
                InputStream is = wsddUrl.openStream();
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                WebservicesFactory factory = new WebservicesFactory(wsddUrl);
                webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
                is.close();
            }
            catch (Exception e) {
                throw new WebServiceException("Failed to unmarshall webservices.xml:" + e.getMessage());
            }
        }
        return webservices;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        WebservicesMetaData webservicesMetaData = new WebservicesMetaData(this.descriptorURL);
        return webservicesMetaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(WebservicesMetaData webservices, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("webservice-description".equals(localName)) {
            return new WebserviceDescriptionMetaData(webservices);
        }
        return null;
    }

    public void addChild(WebservicesMetaData webservices, WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName) {
        webservices.addWebserviceDescription(webserviceDescription);
    }

    public Object newChild(WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("port-component".equals(localName)) {
            return new PortComponentMetaData(webserviceDescription);
        }
        return null;
    }

    public void addChild(WebserviceDescriptionMetaData webserviceDescription, PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName) {
        webserviceDescription.addPortComponent(portComponent);
    }

    public Object newChild(PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("handler".equals(localName)) {
            return new UnifiedHandlerMetaData(null);
        }
        if ("handler-chains".equals(localName)) {
            return new UnifiedHandlerChainsMetaData();
        }
        return null;
    }

    public Object newChild(UnifiedHandlerChainsMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("handler-chain".equals(localName)) {
            return new UnifiedHandlerChainMetaData();
        }
        return null;
    }

    public Object newChild(UnifiedHandlerChainMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("handler".equals(localName)) {
            return new UnifiedHandlerMetaData();
        }
        return null;
    }

    public void addChild(PortComponentMetaData portComponent, UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName) {
        portComponent.addHandler(handler);
    }

    public void addChild(PortComponentMetaData portComponent, UnifiedHandlerChainsMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName) {
        portComponent.setHandlerChains(handlerChains);
    }

    public void addChild(UnifiedHandlerChainsMetaData chains, UnifiedHandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName) {
        chains.addHandlerChain(handlerChain);
    }

    public void addChild(UnifiedHandlerChainMetaData chain, UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName) {
        chain.addHandler(handler);
    }

    public Object newChild(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("init-param".equals(localName)) {
            return new UnifiedInitParamMetaData();
        }
        return null;
    }

    public void addChild(UnifiedHandlerMetaData handler, UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName) {
        handler.addInitParam(param);
    }

    public void setValue(WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("WebserviceDescriptionMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        if (localName.equals("webservice-description-name")) {
            webserviceDescription.setWebserviceDescriptionName(value);
        } else if (localName.equals("wsdl-file")) {
            webserviceDescription.setWsdlFile(value);
        } else if (localName.equals("jaxrpc-mapping-file")) {
            webserviceDescription.setJaxrpcMappingFile(value);
        }
    }

    public void setValue(PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("PortComponentMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        if (localName.equals("port-component-name")) {
            portComponent.setPortComponentName(value);
        } else if (localName.equals("wsdl-port")) {
            portComponent.setWsdlPort(navigator.resolveQName(value));
        } else if (localName.equals("service-endpoint-interface")) {
            portComponent.setServiceEndpointInterface(value);
        } else if (localName.equals("ejb-link")) {
            portComponent.setEjbLink(value);
        } else if (localName.equals("servlet-link")) {
            portComponent.setServletLink(value);
        } else if (localName.equals("wsdl-service")) {
            portComponent.setWsdlService(navigator.resolveQName(value));
        } else if (localName.equals("protocol-binding")) {
            portComponent.setProtocolBinding(value);
        } else if (localName.equals("enable-mtom")) {
            portComponent.setEnableMtom(Boolean.valueOf(value));
        }
    }

    public void setValue(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("UnifiedHandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        if (localName.equals("handler-name")) {
            handler.setHandlerName(value);
        } else if (localName.equals("handler-class")) {
            handler.setHandlerClass(value);
        } else if (localName.equals("soap-header")) {
            handler.addSoapHeader(navigator.resolveQName(value));
        } else if (localName.equals("soap-role")) {
            handler.addSoapRole(value);
        } else if (localName.equals("port-name")) {
            handler.addPortName(value);
        }
    }

    public void setValue(UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("UnifiedInitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        if (localName.equals("param-name")) {
            param.setParamName(value);
        } else if (localName.equals("param-value")) {
            param.setParamValue(value);
        }
    }
}

