/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.drools.ClassObjectFilter;
import org.drools.KnowledgeBase;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.events.PostAuthenticateEvent;
import org.jboss.seam.security.events.PostLoggedOutEvent;
import org.jboss.seam.security.permission.PermissionCheck;
import org.jboss.seam.security.permission.PermissionResolver;
import org.jboss.seam.security.permission.RoleCheck;
import org.jboss.seam.security.qualifiers.Security;
import org.jboss.seam.solder.core.Requires;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.Role;

@Requires(value={"org.drools.KnowledgeBase"})
@SessionScoped
public class RuleBasedPermissionResolver
implements PermissionResolver,
Serializable {
    private static final long serialVersionUID = -7572627522601793024L;
    private StatefulKnowledgeSession securityContext;
    @Inject
    @Security
    KnowledgeBase securityRules;
    @Inject
    BeanManager manager;
    @Inject
    Identity identity;

    @Inject
    public void init() {
        if (this.getSecurityRules() != null) {
            this.setSecurityContext(this.getSecurityRules().newStatefulKnowledgeSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermission(Object resource, String permission) {
        PermissionCheck check;
        StatefulKnowledgeSession securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        StatefulKnowledgeSession statefulKnowledgeSession = securityContext;
        synchronized (statefulKnowledgeSession) {
            if (!(resource instanceof String) && !(resource instanceof Class)) {
                handles.add(securityContext.insert(resource));
            } else if (resource instanceof Class) {
                String componentName = null;
                resource = componentName != null ? componentName : ((Class)resource).getName();
            }
            check = new PermissionCheck(resource, permission);
            try {
                this.synchronizeContext();
                handles.add(securityContext.insert((Object)check));
                securityContext.fireAllRules();
            }
            finally {
                for (FactHandle handle : handles) {
                    securityContext.retract(handle);
                }
            }
        }
        return check.isGranted();
    }

    @Override
    public void filterSetByAction(Set<Object> targets, String action) {
        Iterator<Object> iter = targets.iterator();
        while (iter.hasNext()) {
            Object target = iter.next();
            if (!this.hasPermission(target, action)) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConditionalRole(String roleName, Object target, String action) {
        StatefulKnowledgeSession securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        RoleCheck roleCheck = new RoleCheck(roleName);
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(target, action);
        StatefulKnowledgeSession statefulKnowledgeSession = securityContext;
        synchronized (statefulKnowledgeSession) {
            if (!(target instanceof String) && !(target instanceof Class)) {
                handles.add(securityContext.insert(target));
            } else if (target instanceof Class) {
                String componentName = null;
                target = componentName != null ? componentName : ((Class)target).getName();
            }
            try {
                handles.add(securityContext.insert((Object)check));
                securityContext.fireAllRules();
                this.synchronizeContext();
                handles.add(securityContext.insert((Object)roleCheck));
                handles.add(securityContext.insert((Object)check));
                securityContext.fireAllRules();
            }
            finally {
                for (FactHandle handle : handles) {
                    securityContext.retract(handle);
                }
            }
        }
        return roleCheck.isGranted();
    }

    public void unAuthenticate(@Observes PostLoggedOutEvent event) {
        if (this.getSecurityContext() != null) {
            this.getSecurityContext().dispose();
            this.setSecurityContext(null);
        }
        this.init();
    }

    private void synchronizeContext() {
        if (this.getSecurityContext() != null) {
            boolean found;
            Iterator iter;
            this.getSecurityContext().insert((Object)this.identity.getUser());
            for (Role role : this.identity.getRoles()) {
                iter = this.getSecurityContext().getObjects((ObjectFilter)new ClassObjectFilter(Role.class)).iterator();
                found = false;
                while (iter.hasNext()) {
                    Role r = (Role)iter.next();
                    if (!r.equals(role)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.getSecurityContext().insert((Object)role);
            }
            for (Group group : this.identity.getGroups()) {
                iter = this.getSecurityContext().getObjects((ObjectFilter)new ClassObjectFilter(Group.class)).iterator();
                found = false;
                while (iter.hasNext()) {
                    Group g = (Group)iter.next();
                    if (!g.equals(group)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.getSecurityContext().insert((Object)group);
            }
            for (Role r : this.getSecurityContext().getObjects((ObjectFilter)new ClassObjectFilter(Role.class))) {
                if (this.identity.hasRole(r.getRoleType().getName(), r.getGroup().getName(), r.getGroup().getGroupType())) continue;
                FactHandle fh = this.getSecurityContext().getFactHandle((Object)r);
                this.getSecurityContext().retract(fh);
            }
        }
    }

    public StatefulKnowledgeSession getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(StatefulKnowledgeSession securityContext) {
        this.securityContext = securityContext;
    }

    public KnowledgeBase getSecurityRules() {
        return this.securityRules;
    }

    public void setSecurityRules(KnowledgeBase securityRules) {
        this.securityRules = securityRules;
    }

    public void setUserAccountInSecurityContext(@Observes PostAuthenticateEvent event) {
        if (this.getSecurityContext() != null) {
            this.getSecurityContext().insert((Object)this.identity.getUser());
        }
    }
}

