/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.xml.ContextReplacerVisitor;
import org.teiid.query.optimizer.xml.XMLNodeMappingVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;

public class CriteriaPlanner {
    static void placeUserCriteria(Criteria criteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (Criteria conjunct : Criteria.separateCriteriaByAnd(criteria)) {
            if (CriteriaPlanner.planStagingTableCriteria(conjunct, planEnv) || CriteriaPlanner.planRowLimitFunction(conjunct, criteria, planEnv)) continue;
            MappingNode context = null;
            Collection<Function> contextFunctions = ContextReplacerVisitor.replaceContextFunctions(conjunct);
            if (!contextFunctions.isEmpty()) {
                for (Function contextFunction : contextFunctions) {
                    MappingNode otherContext = CriteriaPlanner.getContext(planEnv, contextFunction);
                    if (context == null) {
                        context = otherContext;
                        continue;
                    }
                    if (context == otherContext) continue;
                    throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30300, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30300, new Object[]{criteria}));
                }
                MappingSourceNode contextRsNode = context.getSourceNode();
                if (contextRsNode != null) {
                    context = contextRsNode;
                }
            } else {
                context = planEnv.mappingDoc;
            }
            Set<MappingSourceNode> sourceNodes = CriteriaPlanner.collectSourceNodesInConjunct(conjunct, context, planEnv.mappingDoc);
            MappingSourceNode criteriaRs = CriteriaPlanner.findRootResultSetNode(context, sourceNodes, criteria);
            ResultSetInfo rs = criteriaRs.getResultSetInfo();
            Criteria convertedCrit = XMLNodeMappingVisitor.convertCriteria(conjunct, planEnv.mappingDoc, planEnv.getGlobalMetadata());
            rs.setCriteria(Criteria.combineCriteria(rs.getCriteria(), convertedCrit));
            rs.addToCriteriaResultSets(sourceNodes);
        }
    }

    private static Set<MappingSourceNode> collectSourceNodesInConjunct(Criteria conjunct, MappingNode context, MappingDocument mappingDoc) throws QueryPlannerException {
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, true);
        HashSet<MappingSourceNode> resultSets = new HashSet<MappingSourceNode>();
        String contextFullName = context.getFullyQualifiedName();
        for (ElementSymbol elementSymbol : elements) {
            String elementFullName = elementSymbol.getName();
            MappingNode node = MappingNode.findNode(mappingDoc, elementFullName);
            MappingSourceNode elementRsNode = node.getSourceNode();
            if (elementRsNode == null) {
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30301, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30301, new Object[]{elementSymbol}));
            }
            String elementRsFullName = elementRsNode.getFullyQualifiedName();
            if (contextFullName.equals(elementRsFullName) || elementRsFullName.startsWith(contextFullName + ".")) {
                resultSets.add(elementRsNode);
                continue;
            }
            if (contextFullName.startsWith(elementRsFullName + ".")) continue;
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30302, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30302, new Object[]{elementSymbol, context.getFullyQualifiedName()}));
        }
        return resultSets;
    }

    private static MappingSourceNode findRootResultSetNode(MappingNode context, Set<MappingSourceNode> resultSets, Criteria criteria) throws QueryPlannerException {
        if (context instanceof MappingSourceNode) {
            return (MappingSourceNode)context;
        }
        HashSet<MappingNode> criteriaResultSets = new HashSet<MappingNode>();
        Iterator<MappingSourceNode> iterator = resultSets.iterator();
        while (iterator.hasNext()) {
            MappingNode node;
            MappingNode root = node = (MappingNode)iterator.next();
            while (node != null) {
                if (node instanceof MappingSourceNode) {
                    root = node;
                }
                node = node.getParent();
            }
            criteriaResultSets.add(root);
        }
        if (criteriaResultSets.size() != 1) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30303, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30303, new Object[]{criteria}));
        }
        return (MappingSourceNode)criteriaResultSets.iterator().next();
    }

    static boolean planStagingTableCriteria(Criteria criteria, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        String rootTempGroupName = CriteriaPlanner.getStagingTableForConjunct(criteria, planEnv.getGlobalMetadata());
        if (rootTempGroupName == null) {
            return false;
        }
        ResultSetInfo rs = planEnv.getStagingTableResultsInfo(rootTempGroupName);
        rs.setCriteria(Criteria.combineCriteria(rs.getCriteria(), criteria));
        return true;
    }

    static boolean planRowLimitFunction(Criteria conjunct, Criteria wholeCrit, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Function rowLimitFunction = null;
        Constant rowLimitConstant = null;
        boolean exceptionOnRowLimit = false;
        if (conjunct instanceof CompareCriteria) {
            Function function;
            CompareCriteria crit = (CompareCriteria)conjunct;
            if (crit.getLeftExpression() instanceof Function) {
                function = (Function)crit.getLeftExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getRightExpression();
                    exceptionOnRowLimit = true;
                }
            }
            if (rowLimitFunction == null && crit.getRightExpression() instanceof Function) {
                function = (Function)crit.getRightExpression();
                if (function.getName().equalsIgnoreCase("rowlimit")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                } else if (function.getName().equalsIgnoreCase("rowlimitexception")) {
                    rowLimitFunction = function;
                    rowLimitConstant = (Constant)crit.getLeftExpression();
                    exceptionOnRowLimit = true;
                }
            }
        }
        if (rowLimitFunction == null) {
            return false;
        }
        int rowLimit = (Integer)rowLimitConstant.getValue();
        String fullyQualifiedNodeName = planEnv.getGlobalMetadata().getFullName(((ElementSymbol)rowLimitFunction.getArg(0)).getMetadataID());
        MappingNode node = MappingNode.findNode(planEnv.mappingDoc, fullyQualifiedNodeName);
        MappingSourceNode sourceNode = node.getSourceNode();
        if (sourceNode == null) {
            String msg = QueryPlugin.Util.getString("XMLPlanner.The_rowlimit_parameter_{0}_is_not_in_the_scope_of_any_mapping_class", new Object[]{fullyQualifiedNodeName});
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30304, msg);
        }
        ResultSetInfo criteriaRsInfo = sourceNode.getResultSetInfo();
        int existingLimit = criteriaRsInfo.getUserRowLimit();
        if (existingLimit > 0 && existingLimit != rowLimit) {
            String msg = QueryPlugin.Util.getString("XMLPlanner.Criteria_{0}_contains_conflicting_row_limits", new Object[]{wholeCrit});
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30305, msg);
        }
        criteriaRsInfo.setUserRowLimit(rowLimit, exceptionOnRowLimit);
        return true;
    }

    static String getStagingTableForConjunct(Criteria conjunct, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Collection<Function> functions;
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)conjunct, true);
        boolean first = true;
        String resultSet = null;
        for (ElementSymbol element : elements) {
            boolean hasTempElement;
            GroupSymbol group = element.getGroupSymbol();
            boolean bl = hasTempElement = !metadata.isXMLGroup(group.getMetadataID());
            if (!first && hasTempElement && resultSet == null) {
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30306, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30306, new Object[]{conjunct}));
            }
            if (hasTempElement) {
                String currentResultSet = metadata.getFullName(element.getGroupSymbol().getMetadataID());
                if (resultSet != null && !resultSet.equalsIgnoreCase(currentResultSet)) {
                    throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30307, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30307, new Object[]{conjunct}));
                }
                resultSet = currentResultSet;
            }
            first = false;
        }
        if (resultSet != null && !(functions = ContextReplacerVisitor.replaceContextFunctions(conjunct)).isEmpty()) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30308, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30308, new Object[0]));
        }
        return resultSet;
    }

    static MappingNode getContext(XMLPlannerEnvironment planEnv, Function contextFunction) throws QueryPlannerException {
        ElementSymbol targetContext = (ElementSymbol)contextFunction.getArg(0);
        MappingNode contextNode = MappingNode.findNode(planEnv.mappingDoc, targetContext.getName());
        if (contextNode == null) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30309, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30309, new Object[]{targetContext}));
        }
        return contextNode;
    }
}

