/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.teiid.language.SortSpecification;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.translator.ExecutionFactory;

public class ListNestedSortComparator<T extends Comparable<? super T>>
implements Comparator<List<T>> {
    private int[] sortParameters;
    private boolean ascendingOrder = false;
    private List<Boolean> orderTypes = null;
    private boolean isDistinct = true;
    private int distinctIndex;
    private List<SortSpecification.NullOrdering> nullOrdering;
    private boolean init;
    private int nullValue = -1;
    private ExecutionFactory.NullOrder defaultNullOrder = ExecutionFactory.NullOrder.LOW;

    public ListNestedSortComparator(int[] sortParameters) {
        this(sortParameters, true);
    }

    public ListNestedSortComparator(int[] sortParameters, boolean ascending) {
        this.sortParameters = sortParameters;
        this.ascendingOrder = ascending;
    }

    public ListNestedSortComparator(int[] sortParameters, List<Boolean> orderTypes) {
        this.sortParameters = sortParameters;
        this.orderTypes = orderTypes;
    }

    public ListNestedSortComparator<T> defaultNullOrder(ExecutionFactory.NullOrder order) {
        this.defaultNullOrder = order;
        return this;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinctIndex(int distinctIndex) {
        this.distinctIndex = distinctIndex;
    }

    public void setNullOrdering(List<SortSpecification.NullOrdering> nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    @Override
    public int compare(List<T> list1, List<T> list2) {
        if (!this.init) {
            if (this.nullOrdering == null) {
                this.nullOrdering = Collections.nCopies(this.sortParameters.length, null);
            }
            for (int i = 0; i < this.sortParameters.length; ++i) {
                if (this.nullOrdering.get(i) != null) continue;
                if (this.defaultNullOrder == ExecutionFactory.NullOrder.FIRST) {
                    this.nullOrdering.set(i, SortSpecification.NullOrdering.FIRST);
                    continue;
                }
                if (this.defaultNullOrder != ExecutionFactory.NullOrder.LAST) continue;
                this.nullOrdering.set(i, SortSpecification.NullOrdering.LAST);
            }
            if (this.defaultNullOrder == ExecutionFactory.NullOrder.HIGH) {
                this.nullValue = 1;
            }
            this.init = true;
        }
        int compare = 0;
        for (int k = 0; k < this.sortParameters.length; ++k) {
            SortSpecification.NullOrdering no;
            if (list1.size() <= this.sortParameters[k]) {
                return 1;
            }
            Comparable param1 = (Comparable)list1.get(this.sortParameters[k]);
            if (list2.size() <= this.sortParameters[k]) {
                return -1;
            }
            Comparable param2 = (Comparable)list2.get(this.sortParameters[k]);
            if (param1 == null) {
                if (param2 == null) {
                    compare = 0;
                } else {
                    compare = this.nullValue;
                    no = this.getNullOrdering(k);
                    if (no == SortSpecification.NullOrdering.FIRST) {
                        return -1;
                    }
                    if (no == SortSpecification.NullOrdering.LAST) {
                        return 1;
                    }
                }
            } else if (param2 == null) {
                compare = -this.nullValue;
                no = this.getNullOrdering(k);
                if (no == SortSpecification.NullOrdering.FIRST) {
                    return 1;
                }
                if (no == SortSpecification.NullOrdering.LAST) {
                    return -1;
                }
            } else {
                compare = Constant.COMPARATOR.compare(param1, param2);
            }
            if (compare != 0) {
                boolean asc = this.orderTypes != null ? this.orderTypes.get(k) : this.ascendingOrder;
                return asc ? compare : -compare;
            }
            if (k != this.distinctIndex) continue;
            this.isDistinct = false;
        }
        return 0;
    }

    private SortSpecification.NullOrdering getNullOrdering(int index) {
        return this.nullOrdering.get(index);
    }

    public int[] getSortParameters() {
        return this.sortParameters;
    }

    public void setSortParameters(int[] sortParameters) {
        this.sortParameters = sortParameters;
    }

    public List<Boolean> getOrderTypes() {
        return this.orderTypes;
    }

    public void setOrderTypes(List<Boolean> orderTypes) {
        this.orderTypes = orderTypes;
    }
}

