/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jboss.dmr.ModelNode;

@Mojo(name="publish-build", requiresProject=true)
public class BuildPublisherMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private boolean targetDestiniation;
    @Parameter(name="forcePublish", property="org.jboss.tools.releng.publish.force")
    private boolean forcePublish;
    @Parameter
    private boolean publishIfGitChanges;
    @Parameter
    private boolean publishIfp2RepoChanges;
    @Parameter
    private String baselineRepo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-repository".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Ignore artifact with packaging != eclipse-repository");
            return;
        }
        File fullSite = new File(this.project.getBuild().getOutputDirectory(), "fullSite");
        if (!fullSite.isDirectory()) {
            throw new MojoFailureException("Expected to find a site to publish in " + fullSite);
        }
        boolean publish = this.forcePublish;
        if (!publish && this.publishIfGitChanges) {
            URL buildInfoURL = null;
            ModelNode buildInfo = null;
            String previousCommitId = null;
            InputStream in = null;
            try {
                buildInfoURL = new URL(this.baselineRepo + "/all/repo/" + "buildinfo.json");
                in = buildInfoURL.openStream();
                buildInfo = ModelNode.fromJSONStream((InputStream)in);
                previousCommitId = buildInfo.get("revision").get("HEAD").asString();
                File repoRoot = this.project.getBasedir();
                while (!new File(repoRoot, ".git").isDirectory()) {
                    repoRoot = repoRoot.getParentFile();
                }
                if (repoRoot == null) {
                    throw new FileNotFoundException("Could not find a Git repository (with a .git child folder)");
                }
                FileRepositoryBuilder builder = new FileRepositoryBuilder();
                Repository gitRepo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(repoRoot, ".git"))).readEnvironment()).findGitDir()).build();
                Ref head = gitRepo.getRef("HEAD");
                publish = !head.getObjectId().getName().equals(previousCommitId);
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (MalformedURLException ex) {
                throw new MojoFailureException("Incorrect URL for buildinfo.json", (Throwable)ex);
                catch (IOException ex2) {
                    this.getLog().warn((CharSequence)("Could not access " + buildInfoURL.toString()), (Throwable)ex2);
                }
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        if (publish || this.publishIfp2RepoChanges) {
            // empty if block
        }
        if (!publish) return;
    }
}

