/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="create-full-site", defaultPhase=LifecyclePhase.DEPLOY, requiresProject=true)
public class CreateFullSiteMojo
extends AbstractMojo {
    public static final String FULL_SITE_FOLDER_NAME = "fullSite";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-repository".equals(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Skipped for projects which have packaging != eclipse-repository");
            return;
        }
        File fullSite = new File(this.project.getBuild().getDirectory(), FULL_SITE_FOLDER_NAME);
        fullSite.mkdirs();
        File all = new File(fullSite, "all");
        all.mkdir();
        File repo = new File(all, "repo");
        repo.mkdir();
        File logs = new File(fullSite, "logs");
        logs.mkdir();
        File repository = new File(this.project.getBuild().getDirectory(), "repository");
        try {
            FileUtils.copyDirectory((File)repository, (File)new File(fullSite, "all/repo"));
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not copy p2 repository", (Throwable)e);
        }
        try {
            this.createRevisionFile(logs);
        }
        catch (FileNotFoundException ex) {
            this.getLog().error((CharSequence)"Could not generate revision file. No Git repository found.");
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not generate revision file", (Throwable)ex);
        }
        try {
            this.createBuildProperties(logs);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not generate properties file", (Throwable)ex);
        }
        ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(new File(all, "repository.zip"));
        archiver.addDirectory(repository);
        try {
            archiver.createArchive();
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not create zip for p2 repository", (Throwable)ex);
        }
    }

    private void createRevisionFile(File logs) throws IOException, FileNotFoundException {
        File repoRoot = logs;
        while (!new File(repoRoot, ".git").isDirectory()) {
            repoRoot = repoRoot.getParentFile();
        }
        if (repoRoot == null) {
            throw new FileNotFoundException("Could not find a Git repository (with a .git child folder)");
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository gitRepo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(repoRoot, ".git"))).readEnvironment()).findGitDir()).build();
        Properties revProperties = new Properties();
        Ref head = gitRepo.getRef("HEAD");
        revProperties.put("HEAD", head.getObjectId().getName());
        for (Map.Entry entry : gitRepo.getAllRefs().entrySet()) {
            if (!((String)entry.getKey()).startsWith("refs/remotes/") || !((Ref)entry.getValue()).getObjectId().getName().equals(head.getObjectId().getName())) continue;
            int lastSlashIndex = ((String)entry.getKey()).lastIndexOf(47);
            String remoteName = ((String)entry.getKey()).substring("refs/remotes/".length(), lastSlashIndex);
            String remoteUrl = gitRepo.getConfig().getString("remote", remoteName, "url");
            String branchName = ((String)entry.getKey()).substring(lastSlashIndex + 1);
            revProperties.put(remoteUrl + ":" + branchName, ((Ref)entry.getValue()).getObjectId().getName());
        }
        File gitRevisionFile = new File(logs, "GIT_REVISION.txt");
        gitRevisionFile.createNewFile();
        FileOutputStream gitRevisionOut = new FileOutputStream(gitRevisionFile);
        revProperties.store(gitRevisionOut, null);
        gitRevisionOut.close();
    }

    private void createBuildProperties(File logFolder) throws IOException {
        StringBuilder content = new StringBuilder();
        this.addPropertyLine(content, "BUILD_ALIAS");
        this.addPropertyLine(content, "JOB_NAME");
        this.addPropertyLine(content, "BUILD_NUMBER");
        this.addPropertyLine(content, "BUILD_TIMESTAMP");
        this.addPropertyLine(content, "HUDSON_SLAVE");
        this.addPropertyLine(content, "RELEASE");
        this.addPropertyLine(content, "ZIPSUFFIX");
        this.addPropertyLine(content, "TARGET_PLATFORM_VERSION");
        this.addPropertyLine(content, "TARGET_PLATFORM_VERSION_MAXIMUM");
        this.addPropertyLine(content, "os.name");
        this.addPropertyLine(content, "os.version");
        this.addPropertyLine(content, "os.arch");
        this.addPropertyLine(content, "java.vendor");
        this.addPropertyLine(content, "java.version");
        File targetFile = new File(logFolder, "build.properties");
        targetFile.createNewFile();
        FileUtils.writeStringToFile((File)targetFile, (String)content.toString());
    }

    private void addPropertyLine(StringBuilder target, String propertyName) {
        target.append(propertyName);
        target.append('=');
        target.append(System.getProperty(propertyName));
        target.append(System.lineSeparator());
    }
}

