/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.tools.tycho.sitegenerator.GenerateRepositoryFacadeMojo;
import org.jboss.tools.tycho.sitegenerator.StreamGobbler;

@Mojo(name="fetch-sources-from-manifests", defaultPhase=LifecyclePhase.PACKAGE)
public class FetchSourcesFromManifests
extends AbstractMojo {
    private static final int CACHE_ZIPS = 1;
    private static final int PURGE_ZIPS = 2;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private Map<String, String> sourceFetchMap;
    @Parameter(property="fetch-sources-from-manifests.zipCacheFolder", defaultValue="${basedir}/cache")
    private File zipCacheFolder;
    @Parameter(property="fetch-sources-from-manifests.outputFolder", defaultValue="${basedir}/zips")
    private File outputFolder;
    @Parameter(property="fetch-sources-from-manifests.zipsDirectory", defaultValue="${basedir}/zips/all")
    private File zipsDirectory;
    @Parameter(property="fetch-sources-from-manifests.sourcesZip", defaultValue="${project.build.directory}/fullSite/all/jbosstools-src.zip")
    private File sourcesZip;
    @Parameter(property="fetch-sources-from-manifests.sourcesZipRootFolder", defaultValue="sources")
    private String sourcesZipRootFolder;
    @Parameter(property="fetch-sources-from-manifests.columnSeparator", defaultValue=",")
    private String columnSeparator;
    @Parameter(property="fetch-sources-from-manifests.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="skipCheckSHAs", defaultValue="true")
    private boolean skipCheckSHAs;
    Properties allBuildProperties = new Properties();
    Set<File> zipFiles = new HashSet<File>();
    @Component
    private WagonManager wagonManager;
    private String MANIFEST = "MANIFEST.MF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            String wrongZips;
            File[] wrongZipFiles;
            File outputZipFile;
            String upstreamProjectName;
            String upstreamSHA;
            ModelNode obj;
            FileInputStream in;
            File[] buildInfoFiles;
            File buildinfoFolder;
            String outputZipName;
            if (this.zipCacheFolder == null) {
                this.zipCacheFolder = new File(this.project.getBasedir() + File.separator + "cache" + File.separator);
            }
            if (this.zipCacheFolder != null && !this.zipCacheFolder.isDirectory()) {
                try {
                    if (!this.zipCacheFolder.exists()) {
                        this.zipCacheFolder.mkdirs();
                    }
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("'zipCacheFolder' must be a directory", ex);
                }
            }
            if (this.outputFolder == null) {
                this.outputFolder = new File(this.project.getBasedir() + File.separator + "zips" + File.separator);
            }
            if (this.outputFolder.equals(this.zipCacheFolder)) {
                throw new MojoExecutionException("zipCacheFolder and outputFolder can not be the same folder");
            }
            this.zipsDirectory = new File(this.outputFolder, "all");
            if (!this.zipsDirectory.exists()) {
                this.zipsDirectory.mkdirs();
            }
            File digestFile = new File(this.outputFolder, "ALL_REVISIONS.txt");
            StringBuffer sb = new StringBuffer();
            String branch = this.project.getProperties().getProperty("mvngit.branch");
            sb.append("-=> " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + this.columnSeparator + branch + " <=-\n");
            String pluginPath = this.project.getBasedir() + File.separator + "target" + File.separator + "repository" + File.separator + "plugins";
            String sep = " " + this.columnSeparator + " ";
            if (this.sourceFetchMap == null) {
                this.getLog().warn((CharSequence)"No <sourceFetchMap> defined in pom. Can't fetch sources without a list of plugins. Did you forget to enable fetch-source-zips profile?");
            } else {
                for (String projectName : this.sourceFetchMap.keySet()) {
                    String pluginNameOrBuildInfoJsonUrl = this.sourceFetchMap.get(projectName);
                    this.getLog().debug((CharSequence)("For project " + projectName + ": plugin name or buildinfo.json = " + pluginNameOrBuildInfoJsonUrl));
                    String SHA = null;
                    String qualifier = null;
                    String SHASource = null;
                    if ((pluginNameOrBuildInfoJsonUrl.startsWith("http") || pluginNameOrBuildInfoJsonUrl.startsWith("ftp")) && pluginNameOrBuildInfoJsonUrl.matches(".+buildinfo.*json")) {
                        ModelNode obj2;
                        this.getLog().debug((CharSequence)("Read JSON from: " + pluginNameOrBuildInfoJsonUrl));
                        try {
                            obj2 = ModelNode.fromJSONStream((InputStream)new URL(pluginNameOrBuildInfoJsonUrl).openStream());
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Problem occurred reading " + pluginNameOrBuildInfoJsonUrl, (Exception)e);
                        }
                        SHA = this.getSHA(obj2);
                        this.getLog().debug((CharSequence)("Found SHA = " + SHA));
                        qualifier = this.getProperty(obj2, "BUILD_ALIAS") + "-" + this.getProperty(obj2, "ZIPSUFFIX");
                        this.getLog().debug((CharSequence)("Found qualifier = " + qualifier));
                        SHASource = pluginNameOrBuildInfoJsonUrl;
                    } else {
                        Manifest manifest;
                        File[] matchingFiles = FetchSourcesFromManifests.listFilesMatching(new File(pluginPath), pluginNameOrBuildInfoJsonUrl + "_.+\\.jar");
                        if (matchingFiles.length < 1) {
                            throw new MojoExecutionException("No matching plugin found in " + pluginPath + " for " + pluginNameOrBuildInfoJsonUrl + "_.+\\.jar.\nCheck your pom.xml for this line: <" + projectName + ">" + pluginNameOrBuildInfoJsonUrl + "</" + projectName + ">");
                        }
                        File jarFile = matchingFiles[0];
                        File manifestFile = null;
                        try {
                            FileInputStream fin = new FileInputStream(jarFile);
                            manifestFile = File.createTempFile(this.MANIFEST, "");
                            FileOutputStream out = new FileOutputStream(manifestFile);
                            BufferedInputStream bin = new BufferedInputStream(fin);
                            ZipInputStream zin = new ZipInputStream(bin);
                            ZipEntry ze = null;
                            while ((ze = zin.getNextEntry()) != null) {
                                int len;
                                if (!ze.getName().equals("META-INF/" + this.MANIFEST)) continue;
                                byte[] buffer = new byte[8192];
                                while ((len = zin.read(buffer)) != -1) {
                                    ((OutputStream)out).write(buffer, 0, len);
                                }
                                ((OutputStream)out).close();
                                break;
                            }
                            zin.close();
                        }
                        catch (Exception ex) {
                            throw new MojoExecutionException("Error extracting " + this.MANIFEST + " from " + jarFile, ex);
                        }
                        try {
                            manifest = new Manifest(new FileInputStream(manifestFile));
                        }
                        catch (Exception ex) {
                            throw new MojoExecutionException("Error while reading manifest file " + this.MANIFEST, ex);
                        }
                        Attributes attr = manifest.getMainAttributes();
                        String ESR = null;
                        SHA = null;
                        ESR = attr.getValue("Eclipse-SourceReferences");
                        SHA = ESR != null ? ESR.substring(ESR.lastIndexOf(";commitId=") + 10) : "UNKNOWN";
                        manifestFile.delete();
                        qualifier = this.getQualifier(pluginNameOrBuildInfoJsonUrl, jarFile.toString(), true);
                        SHASource = this.removePrefix(jarFile.toString(), pluginPath) + " " + this.MANIFEST;
                    }
                    String URL2 = "";
                    outputZipName = "";
                    try {
                        if (SHA == null || SHA.equals("UNKNOWN")) {
                            this.getLog().warn((CharSequence)("Cannot fetch " + projectName + " sources: no Eclipse-SourceReferences in " + SHASource));
                        } else {
                            URL2 = "https://github.com/jbosstools/" + projectName + "/archive/" + SHA + ".zip";
                            outputZipName = projectName + "_" + SHA + "_sources.zip";
                            this.fetchUpstreamSourcesZip(projectName, SHA);
                        }
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Error while downloading github source archive", ex);
                    }
                    String revisionLine = projectName + sep + pluginNameOrBuildInfoJsonUrl + sep + qualifier + sep + SHA + sep + "origin/" + branch + "@" + SHA + sep + URL2 + sep + outputZipName + "\n";
                    sb.append(revisionLine);
                }
            }
            if (this.skipCheckSHAs) {
                this.getLog().warn((CharSequence)"skipCheckSHAs=true :: Skip check that buildinfo_*.json HEAD SHA matches MANIFEST.MF Eclipse-SourceReferences commitId SHA.");
            } else {
                buildinfoFolder = new File(this.project.getBuild().getDirectory(), "buildinfo");
                if (buildinfoFolder.isDirectory()) {
                    try {
                        buildInfoFiles = FetchSourcesFromManifests.listFilesMatching(buildinfoFolder, "buildinfo_.+.json");
                        for (int i = 0; i < buildInfoFiles.length; ++i) {
                            in = null;
                            obj = null;
                            upstreamSHA = null;
                            upstreamProjectName = buildInfoFiles[i].toString().replaceAll(".+buildinfo_(.+).json", "$1");
                            this.getLog().debug((CharSequence)(i + ": " + buildInfoFiles[i].toString() + " :: " + upstreamProjectName));
                            try {
                                this.getLog().debug((CharSequence)("Read JSON from: " + buildInfoFiles[i].toString()));
                                in = new FileInputStream(buildInfoFiles[i]);
                                obj = ModelNode.fromJSONStream((InputStream)in);
                                upstreamSHA = this.getSHA(obj);
                                this.getLog().debug((CharSequence)("Found SHA = " + upstreamSHA));
                                outputZipName = upstreamProjectName + "_" + upstreamSHA + "_sources.zip";
                                outputZipFile = new File(this.zipsDirectory, outputZipName);
                                if (!outputZipFile.isFile()) {
                                    this.getLog().debug((CharSequence)("Check " + this.outputFolder.toString() + " for " + upstreamProjectName + "_.+_sources.zip"));
                                    wrongZipFiles = FetchSourcesFromManifests.listFilesMatching(this.zipsDirectory, upstreamProjectName + "_.+_sources.zip");
                                    wrongZips = "";
                                    for (int j = 0; j < wrongZipFiles.length; ++j) {
                                        this.getLog().debug((CharSequence)wrongZipFiles[j].toString());
                                        wrongZips = wrongZips + (wrongZips.isEmpty() ? "" : ", ") + wrongZipFiles[j].toString().replaceAll(".+" + upstreamProjectName + "_(.+)_sources.zip", "$1");
                                    }
                                    if (!wrongZips.isEmpty()) {
                                        throw new MojoFailureException("\n\n" + buildInfoFiles[i].toString() + "\ncontains " + upstreamSHA + ", but upstream " + upstreamProjectName + " project's MANIFEST.MF has Eclipse-SourceReferences \ncommitId " + wrongZips + ". \n\nIf you have locally built projects which are being aggregated here, ensure \nthey are built from the latest SHA from HEAD, not a local topic branch. \n\nIt's also possible that some recent changes have not yet been built upstream. \nIf that's the case, trigger a build for the " + upstreamProjectName + " project \nto ensure that the latest commits have been built and can be aggregated here. \n\nOr, use -DskipCheckSHAs=true to bypass this check.\n\n");
                                    }
                                    this.getLog().warn((CharSequence)("\n" + buildInfoFiles[i].toString() + "\ncontains " + upstreamSHA + ", but upstream " + upstreamProjectName + " project's MANIFEST.MF has no Eclipse-SourceReferences commitId.\nUsing sources from " + upstreamSHA + "."));
                                    this.fetchUpstreamSourcesZip(upstreamProjectName, upstreamSHA);
                                }
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)in);
                        }
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Problem occurred checking upstream buildinfo.json files!", ex);
                    }
                }
            }
            if (this.skipCheckSHAs) {
                this.getLog().warn((CharSequence)"skipCheckSHAs=true :: Skip check that buildinfo_*.json HEAD SHA matches MANIFEST.MF Eclipse-SourceReferences commitId SHA.");
            } else {
                buildinfoFolder = new File(this.project.getBuild().getDirectory(), "buildinfo");
                if (buildinfoFolder.isDirectory()) {
                    try {
                        buildInfoFiles = FetchSourcesFromManifests.listFilesMatching(buildinfoFolder, "buildinfo_.+.json");
                        for (int i = 0; i < buildInfoFiles.length; ++i) {
                            in = null;
                            obj = null;
                            upstreamSHA = null;
                            upstreamProjectName = buildInfoFiles[i].toString().replaceAll(".+buildinfo_(.+).json", "$1");
                            this.getLog().debug((CharSequence)(i + ": " + buildInfoFiles[i].toString() + " :: " + upstreamProjectName));
                            try {
                                this.getLog().debug((CharSequence)("Read JSON from: " + buildInfoFiles[i].toString()));
                                in = new FileInputStream(buildInfoFiles[i]);
                                obj = ModelNode.fromJSONStream((InputStream)in);
                                upstreamSHA = this.getSHA(obj);
                                this.getLog().debug((CharSequence)("Found SHA = " + upstreamSHA));
                                outputZipName = upstreamProjectName + "_" + upstreamSHA + "_sources.zip";
                                outputZipFile = new File(this.zipsDirectory, outputZipName);
                                if (!outputZipFile.isFile()) {
                                    this.getLog().debug((CharSequence)("Check " + this.outputFolder.toString() + " for " + upstreamProjectName + "_.+_sources.zip"));
                                    wrongZipFiles = FetchSourcesFromManifests.listFilesMatching(this.zipsDirectory, upstreamProjectName + "_.+_sources.zip");
                                    wrongZips = "";
                                    for (int j = 0; j < wrongZipFiles.length; ++j) {
                                        this.getLog().debug((CharSequence)wrongZipFiles[j].toString());
                                        wrongZips = wrongZips + (wrongZips.isEmpty() ? "" : ", ") + wrongZipFiles[j].toString().replaceAll(".+" + upstreamProjectName + "_(.+)_sources.zip", "$1");
                                    }
                                    if (!wrongZips.isEmpty()) {
                                        throw new MojoFailureException("\n" + buildInfoFiles[i].toString() + "\ncontains " + upstreamSHA + ", but upstream " + upstreamProjectName + " project's MANIFEST.MF has Eclipse-SourceReferences\ncommitId " + wrongZips + ". \nIf you have locally built projects which are aggregated here, \nensure they are built from the latest SHA from HEAD, not a local topic branch.\nOr, use -DskipCheckSHAs=true to bypass this check.");
                                    }
                                    this.getLog().warn((CharSequence)("\n" + buildInfoFiles[i].toString() + "\ncontains " + upstreamSHA + ", but upstream " + upstreamProjectName + " project's MANIFEST.MF has no Eclipse-SourceReferences commitId.\nUsing sources from " + upstreamSHA + "."));
                                    this.fetchUpstreamSourcesZip(upstreamProjectName, upstreamSHA);
                                }
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)in);
                        }
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Problem occurred checking upstream buildinfo.json files!", ex);
                    }
                }
            }
            this.createCombinedZipFile(this.zipsDirectory, this.zipFiles, 1);
            try {
                File buildPropertiesAllXml = new File(this.outputFolder, "build.properties.all.xml");
                if (!buildPropertiesAllXml.exists()) {
                    buildPropertiesAllXml.createNewFile();
                }
                FileOutputStream xmlOut = new FileOutputStream(buildPropertiesAllXml);
                this.allBuildProperties.storeToXML(xmlOut, null);
                xmlOut.close();
                File buildPropertiesFileTxt = new File(this.outputFolder, "build.properties.file.txt");
                if (!buildPropertiesFileTxt.exists()) {
                    buildPropertiesFileTxt.createNewFile();
                }
                FileOutputStream textOut = new FileOutputStream(buildPropertiesFileTxt);
                this.allBuildProperties.store(textOut, null);
                textOut.close();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error while creating 'metadata' files", ex);
            }
            try {
                FileWriter dfw = new FileWriter(digestFile);
                dfw.write(sb.toString());
                dfw.close();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error writing to " + digestFile.toString(), ex);
            }
        }
        this.getLog().info((CharSequence)"fetch-sources-from-manifests (fetch-sources) :: skipped.");
    }

    private void fetchUpstreamSourcesZip(String projectName, String SHA) throws Exception {
        File cachedZip;
        String URL2 = "https://github.com/jbosstools/" + projectName + "/archive/" + SHA + ".zip";
        String outputZipName = projectName + "_" + SHA + "_sources.zip";
        File outputZipFile = new File(this.zipsDirectory, outputZipName);
        boolean diduseCache = false;
        if (this.zipCacheFolder != null && this.zipCacheFolder.exists() && (cachedZip = new File(this.zipCacheFolder, outputZipName)).exists()) {
            FileUtils.copyFile((File)cachedZip, (File)outputZipFile);
            this.getLog().debug((CharSequence)("Copied " + this.removePrefix(outputZipFile.getAbsolutePath(), this.project.getBasedir().toString())));
            this.getLog().debug((CharSequence)("  From " + this.removePrefix(cachedZip.getAbsolutePath(), this.project.getBasedir().toString())));
            diduseCache = true;
        }
        File[] matchingSourceZips = FetchSourcesFromManifests.listFilesMatching(this.zipCacheFolder, projectName + "_.+\\.zip");
        for (int i = 0; i < matchingSourceZips.length; ++i) {
            if (outputZipFile.getName().equals(matchingSourceZips[i].getName())) continue;
            this.getLog().warn((CharSequence)("Delete " + matchingSourceZips[i].getName()));
            matchingSourceZips[i].delete();
        }
        File[] matchingSourceMD5s = FetchSourcesFromManifests.listFilesMatching(this.zipCacheFolder, projectName + "_.+\\.zip\\.MD5");
        for (int i = 0; i < matchingSourceMD5s.length; ++i) {
            if ((outputZipFile.getName() + ".MD5").equals(matchingSourceMD5s[i].getName())) continue;
            this.getLog().warn((CharSequence)("Delete " + matchingSourceMD5s[i].getName()));
            matchingSourceMD5s[i].delete();
        }
        String outputZipFolder = outputZipFile.toString().replaceAll("_sources.zip", "");
        if (!(diduseCache || outputZipFile.exists() && new File(outputZipFolder).exists())) {
            this.doGet(URL2, outputZipFile, true);
        }
        this.allBuildProperties.put(outputZipName + ".filename", outputZipName);
        this.allBuildProperties.put(outputZipName + ".filesize", Long.toString(outputZipName.length()));
        this.getLog().debug((CharSequence)("Add " + outputZipName + " to zipFiles(" + this.zipFiles.size() + ") ..."));
        this.zipFiles.add(new File(outputZipName));
        this.getLog().debug((CharSequence)("Added to zipFiles(" + this.zipFiles.size() + ")."));
    }

    /*
     * Unable to fully structure code
     */
    private void createCombinedZipFile(File zipsDirectory, Set<File> zipFiles, int mode) throws MojoExecutionException {
        combinedZipName = this.sourcesZip.getAbsolutePath();
        combinedZipFile = new File(combinedZipName);
        fullUnzipPath = zipsDirectory.getAbsolutePath() + File.separator + this.sourcesZipRootFolder;
        fullUnzipDir = new File(fullUnzipPath);
        fullUnzipDir.mkdirs();
        for (File outputFile : zipFiles) {
            try {
                zipFileName = zipsDirectory.getAbsolutePath() + File.separator + outputFile.getName();
                this.getLog().debug((CharSequence)("Unpacking: " + zipFileName));
                this.getLog().debug((CharSequence)("Unpack to: " + fullUnzipPath));
                FetchSourcesFromManifests.unzipToDirectory(zipFileName, fullUnzipPath);
                zipFile = new File(zipFileName);
                if (mode == 2) {
                    this.getLog().debug((CharSequence)("Delete zip: " + zipFileName));
                    zipFile.delete();
                    continue;
                }
                if (mode != 1) continue;
                this.getLog().debug((CharSequence)("Cache " + zipFileName + " in " + this.zipCacheFolder));
                zipFile.renameTo(new File(this.zipCacheFolder, zipFile.getName()));
            }
            catch (ZipException ex) {
                throw new MojoExecutionException("Error unpacking " + outputFile.toString() + " to " + fullUnzipPath, (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error unpacking " + outputFile.toString() + " to " + fullUnzipPath, (Exception)ex);
            }
        }
        properties = new Properties();
        projectURL = null;
        projectName = null;
        projectSHA = null;
        try {
            properties.load(new FileInputStream(this.project.getBuild().getDirectory() + File.separator + "git.properties"));
            this.getLog().debug((CharSequence)("git.remote.origin.url = " + properties.get("git.remote.origin.url").toString()));
            projectURL = properties.get("git.remote.origin.url").toString();
            projectName = projectURL.replaceAll(".+/([^/]+).git", "$1");
            this.getLog().debug((CharSequence)("git.commit.id = " + properties.get("git.commit.id").toString()));
            projectSHA = properties.get("git.commit.id").toString();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error loading " + this.project.getBuild().getDirectory() + File.separator + "git.properties", (Exception)ex);
        }
        localCleanSourcesDir = null;
        if (projectName != null) {
            if (projectSHA == null) {
                throw new MojoExecutionException("Could not compute projectSHA!");
            }
        } else {
            throw new MojoExecutionException("Could not compute projectName or projectSHA!");
        }
        this.getLog().debug((CharSequence)("projectName = " + projectName));
        localCleanSourcesDir = projectName.replaceAll("[@:/]+", "_") + "-" + projectSHA;
        this.getLog().debug((CharSequence)("localCleanSourcesDir = " + localCleanSourcesDir));
        repoRoot = null;
        try {
            repoRoot = GenerateRepositoryFacadeMojo.findRepoRoot(this.project.getBasedir());
        }
        catch (FileNotFoundException ex) {
            throw new MojoExecutionException("Repo root not found in " + this.project.getBasedir(), (Exception)ex);
        }
        this.getLog().debug((CharSequence)("repoRoot = " + repoRoot));
        gitSourcesArchive = new File("/tmp/" + localCleanSourcesDir + ".zip");
        this.getLog().debug((CharSequence)("cd " + repoRoot + "; git archive --prefix " + localCleanSourcesDir + " -o " + gitSourcesArchive + " HEAD"));
        command = "git archive --prefix " + localCleanSourcesDir + "/ -o " + gitSourcesArchive + " HEAD";
        try {
            rt = Runtime.getRuntime();
            proc = rt.exec(command, null, repoRoot);
            errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            exitVal = proc.waitFor();
            this.getLog().debug((CharSequence)("Runtime.getRuntime.exec() - exit value: " + exitVal));
            this.getLog().debug((CharSequence)("Packed to: " + gitSourcesArchive));
            filesize = gitSourcesArchive.length();
            this.getLog().debug((CharSequence)("Pack size: " + (filesize >= 1048576.0 ? String.format("%.1f", new Object[]{filesize / 1024.0 / 1024.0}) + " M" : String.format("%.1f", new Object[]{filesize / 1024.0}) + " k")));
            FetchSourcesFromManifests.unzipToDirectory(gitSourcesArchive, fullUnzipPath);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error cloning from " + repoRoot.toString() + " to " + gitSourcesArchive, (Exception)ex);
        }
        catch (InterruptedException ex) {
            throw new MojoExecutionException("Error cloning from " + repoRoot.toString() + " to " + gitSourcesArchive, (Exception)ex);
        }
        buildinfoFolder = new File(this.project.getBuild().getDirectory(), "buildinfo");
        if (buildinfoFolder.isDirectory()) {
            try {
                buildinfoFolderCopy = new File(fullUnzipPath, "buildinfo");
                FileUtils.copyDirectory((File)buildinfoFolder, (File)buildinfoFolderCopy);
                this.getLog().debug((CharSequence)("Pack from: " + buildinfoFolderCopy));
                dupeUpstreamBuildinfoFile = new File(buildinfoFolderCopy + File.separator + "buildinfo_" + projectName + ".json");
                if (!dupeUpstreamBuildinfoFile.isFile()) ** GOTO lbl93
                dupeUpstreamBuildinfoFile.delete();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying buildinfo files to " + fullUnzipPath + File.separator + "buildinfo", (Exception)e);
            }
        } else {
            this.getLog().warn((CharSequence)("No buildinfo files found in " + buildinfoFolder.toString()));
        }
lbl93:
        // 3 sources

        try {
            this.getLog().debug((CharSequence)("Pack from: " + fullUnzipPath));
            FetchSourcesFromManifests.zipDirectory(fullUnzipDir.getParentFile(), combinedZipFile);
            this.getLog().debug((CharSequence)("Packed to: " + combinedZipFile.getAbsolutePath()));
            filesize = combinedZipFile.length();
            this.getLog().debug((CharSequence)("Pack size: " + (filesize >= 1048576.0 ? String.format("%.1f", new Object[]{filesize / 1024.0 / 1024.0}) + " M" : String.format("%.1f", new Object[]{filesize / 1024.0}) + " k")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error packing " + combinedZipFile, (Exception)e);
        }
        try {
            this.getLog().debug((CharSequence)("Delete dir: " + fullUnzipPath));
            FileUtils.deleteDirectory((File)new File(fullUnzipPath));
            gitSourcesArchive.delete();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("IO Exception:", (Exception)ex);
        }
    }

    public static void unzipToDirectory(String zipFile, String newPath) throws ZipException, IOException {
        FetchSourcesFromManifests.unzipToDirectory(new File(zipFile), newPath);
    }

    public static void unzipToDirectory(File file, String newPath) throws ZipException, IOException {
        int BUFFER = 2048;
        ZipFile zip = new ZipFile(file);
        new File(newPath).mkdirs();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(newPath, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
        zip.close();
    }

    public static void zipDirectory(File dir, File zipFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(zipFile);
        ZipOutputStream zout = new ZipOutputStream(fout);
        FetchSourcesFromManifests.zipSubDirectory("", dir, zout);
        zout.flush();
        zout.close();
        fout.flush();
        fout.close();
    }

    private static void zipSubDirectory(String basePath, File dir, ZipOutputStream zout) throws IOException {
        File[] files;
        byte[] buffer = new byte[4096];
        for (File file : files = dir.listFiles()) {
            int length;
            if (file.isDirectory()) {
                String path = basePath + file.getName() + "/";
                zout.putNextEntry(new ZipEntry(path));
                FetchSourcesFromManifests.zipSubDirectory(path, file, zout);
                zout.closeEntry();
                continue;
            }
            FileInputStream fin = new FileInputStream(file);
            zout.putNextEntry(new ZipEntry(basePath + file.getName()));
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
            fin.close();
        }
    }

    private String removePrefix(String stringToTrim, String prefix) {
        return stringToTrim.substring(stringToTrim.lastIndexOf(prefix) + prefix.length() + 1);
    }

    private String getQualifier(String pluginName, String jarFileName, boolean full) {
        String qualifier = this.removePrefix(jarFileName, pluginName);
        qualifier = qualifier.substring(0, qualifier.length() - 4);
        return full ? qualifier : qualifier.replaceAll("^(\\d+\\.\\d+\\.\\d+\\.)", "");
    }

    public static File[] listFilesMatching(File root, String regex) throws MojoExecutionException {
        if (!root.isDirectory()) {
            throw new MojoExecutionException(root + " is not a directory.");
        }
        final Pattern p = Pattern.compile(regex);
        return root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return p.matcher(file.getName()).matches();
            }
        });
    }

    private void doGet(String url, File outputFile, boolean unpack) throws Exception {
        String[] segments = url.split("/");
        String file = segments[segments.length - 1];
        String repoUrl = url.substring(0, url.length() - file.length() - 1);
        Repository repository = new Repository(repoUrl, repoUrl);
        Wagon wagon = this.wagonManager.getWagon(repository.getProtocol());
        wagon.connect(repository, this.wagonManager.getProxy(repository.getProtocol()));
        wagon.get(file, outputFile);
        wagon.disconnect();
        double filesize = outputFile.length();
        this.getLog().info((CharSequence)("Downloaded:  " + outputFile.getName() + " (" + (filesize >= 1048576.0 ? String.format("%.1f", filesize / 1024.0 / 1024.0) + " M)" : String.format("%.1f", filesize / 1024.0) + " k)")));
    }

    private String getSHA(ModelNode obj) {
        String projectSHA = null;
        for (Property prop : obj.get("revision").asPropertyList()) {
            if (projectSHA != null || !prop.getName().equals("HEAD")) continue;
            projectSHA = prop.getValue().asString();
            this.getLog().debug((CharSequence)("Upstream SHA: " + projectSHA));
        }
        return projectSHA;
    }

    private String getProperty(ModelNode obj, String propertyName) {
        String theProperty = null;
        for (Property prop : obj.get("properties").asPropertyList()) {
            if (theProperty != null || !prop.getName().equals(propertyName)) continue;
            theProperty = prop.getValue().asString();
            this.getLog().debug((CharSequence)("Upstream " + propertyName + ": " + theProperty));
        }
        return theProperty;
    }
}

