/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Mojo(name="fetch-zips-for-aggregate", defaultPhase=LifecyclePhase.PACKAGE)
public class FetchZipsFromRepo
extends AbstractMojo {
    @Parameter
    private List<URL> repositories;
    @Parameter(property="fetch-zips-for-aggregate.zipCacheFolder")
    private File zipCacheFolder;
    @Parameter(property="fetch-zips-for-aggregate.outputFolder", defaultValue="${basedir}/zips")
    private File outputFolder;
    @Parameter(property="fetch-zips-for-aggregate.skip", defaultValue="false")
    private boolean skip;
    @Component
    private WagonManager wagonManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.repositories == null || this.repositories.isEmpty()) {
            return;
        }
        if (this.zipCacheFolder != null && !this.zipCacheFolder.isDirectory()) {
            throw new MojoExecutionException("'zipCacheDir' must be a directory");
        }
        if (this.outputFolder.equals(this.zipCacheFolder)) {
            throw new MojoExecutionException("Same value for zipCacheDir and outputFolder is not allowed");
        }
        ArrayList<String> componentRepositories = new ArrayList<String>();
        for (URL repository : this.repositories) {
            try {
                URL compositeArtifactsURL = new URL(repository, "compositeArtifacts.xml");
                File[] stream = null;
                stream = compositeArtifactsURL.openStream();
                Document compositeArtifactsDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)stream);
                stream.close();
                NodeList children = ((Element)((Element)compositeArtifactsDoc.getElementsByTagName("repository").item(0)).getElementsByTagName("children").item(0)).getElementsByTagName("child");
                for (int i = 0; i < children.getLength(); ++i) {
                    Element child = (Element)children.item(i);
                    URI location = new URI(child.getAttribute("location"));
                    if (location.toString().contains("/staging.previous/")) continue;
                    if (location.isAbsolute()) {
                        componentRepositories.add(location.toString());
                        continue;
                    }
                    componentRepositories.add(new URL(repository, location.toString()).toString());
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Repository " + repository.toString() + " is NOT a COMPOSITE repository");
            }
        }
        File zipsDirectory = new File(this.outputFolder, "all");
        if (!zipsDirectory.exists()) {
            zipsDirectory.mkdir();
        }
        HashSet<File> writtenFiles = new HashSet<File>();
        Properties allBuildProperties = new Properties();
        for (String componentRepository : componentRepositories) {
            while (componentRepository.charAt(componentRepository.length() - 1) == '/') {
                componentRepository = componentRepository.substring(0, componentRepository.length() - 1);
            }
            if (componentRepository.endsWith("/repo")) {
                componentRepository = componentRepository.substring(0, componentRepository.length() - "/repo".length());
            }
            if (componentRepository.endsWith("/all")) {
                componentRepository = componentRepository.substring(0, componentRepository.length() - "/all".length());
            }
            this.getLog().info((CharSequence)("Getting zips and metadata from repo '" + componentRepository + "'"));
            try {
                Repository wagonRepository = new Repository(componentRepository, componentRepository);
                Wagon wagon = this.wagonManager.getWagon(wagonRepository.getProtocol());
                wagon.connect(wagonRepository);
                String buildPropertiesPrefix = null;
                InputStream zipListStreamm = null;
                try {
                    zipListStreamm = new URL(componentRepository + "/logs/zip.list.txt").openStream();
                }
                catch (Exception ex) {
                    this.getLog().warn((CharSequence)("Could not get zip.list.txt for repo " + componentRepository + ". Ignoring reposiotry."));
                    continue;
                }
                Properties zipListProperties = new Properties();
                zipListProperties.load(zipListStreamm);
                zipListStreamm.close();
                for (String zip : zipListProperties.getProperty("ALL_ZIPS").split(",")) {
                    if (!(zip = zip.trim()).isEmpty()) {
                        String computedMD5;
                        String[] segments = zip.split("/");
                        String zipName = segments[segments.length - 1];
                        if (buildPropertiesPrefix == null) {
                            buildPropertiesPrefix = zipName.replace("-Update", "").replace("-Sources", "").replace(".zip", "") + ".build.properties.";
                        }
                        File outputZipFile = new File(zipsDirectory, zipName);
                        File outputMD5File = new File(outputZipFile.getAbsolutePath() + ".MD5");
                        wagon.get(zip + ".MD5", outputMD5File);
                        FileInputStream md5is = new FileInputStream(outputMD5File);
                        BufferedReader md5reader = new BufferedReader(new InputStreamReader(md5is));
                        String retrievedMD5 = md5reader.readLine();
                        ((InputStream)md5is).close();
                        String md5 = null;
                        if (outputZipFile.exists() && retrievedMD5.equals(computedMD5 = FetchZipsFromRepo.getMD5(outputZipFile))) {
                            md5 = retrievedMD5;
                            this.getLog().info((CharSequence)("  No change for " + outputZipFile.getAbsolutePath()));
                        }
                        if (md5 == null) {
                            File cachedZip;
                            boolean useCache = false;
                            if (this.zipCacheFolder != null && (cachedZip = new File(this.zipCacheFolder, outputZipFile.getName())).exists() && FetchZipsFromRepo.getMD5(cachedZip).equals(retrievedMD5)) {
                                FileUtils.copyFile((File)cachedZip, (File)outputZipFile);
                                this.getLog().info((CharSequence)("  Got " + outputZipFile.getAbsolutePath() + " from " + cachedZip.getAbsolutePath()));
                                useCache = true;
                            }
                            if (!useCache) {
                                wagon.get(zip, outputZipFile);
                                this.getLog().info((CharSequence)("  Got " + outputZipFile.getAbsolutePath() + " from " + wagon.getRepository().getUrl()));
                                if (this.zipCacheFolder != null) {
                                    cachedZip = new File(this.zipCacheFolder, outputZipFile.getName());
                                    if (!cachedZip.exists()) {
                                        cachedZip.createNewFile();
                                    }
                                    FileUtils.copyFile((File)cachedZip, (File)outputZipFile);
                                    this.getLog().info((CharSequence)("    Installed in cache: " + cachedZip.getAbsolutePath()));
                                }
                            }
                            md5 = FetchZipsFromRepo.getMD5(outputZipFile);
                        }
                        allBuildProperties.put(zipName + ".filename", zip);
                        allBuildProperties.put(zipName + ".filesize", Long.toString(outputZipFile.length()));
                        allBuildProperties.put(zipName + ".filemd5", md5);
                        writtenFiles.add(outputMD5File);
                        writtenFiles.add(outputZipFile);
                    }
                    InputStream buildPropertiesStream = new URL(componentRepository + "/logs/build.properties").openStream();
                    Properties componentBuildProperties = new Properties();
                    componentBuildProperties.load(buildPropertiesStream);
                    buildPropertiesStream.close();
                    for (Map.Entry<Object, Object> entry : componentBuildProperties.entrySet()) {
                        String qualifiedKey = buildPropertiesPrefix + (String)entry.getKey();
                        allBuildProperties.put(qualifiedKey, entry.getValue());
                    }
                }
                wagon.disconnect();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error while transferring zips from repository '" + componentRepository + "'", ex);
            }
        }
        for (File zip : zipsDirectory.listFiles()) {
            if (writtenFiles.contains(zip)) continue;
            zip.delete();
        }
        this.getLog().info((CharSequence)"Generating aggregate components metadata");
        try {
            File buildPropertiesAllXml = new File(this.outputFolder, "build.properties.all.xml");
            if (!buildPropertiesAllXml.exists()) {
                buildPropertiesAllXml.createNewFile();
            }
            FileOutputStream xmlOut = new FileOutputStream(buildPropertiesAllXml);
            allBuildProperties.storeToXML(xmlOut, null);
            xmlOut.close();
            File buildPropertiesFileTxt = new File(this.outputFolder, "build.properties.file.txt");
            if (!buildPropertiesFileTxt.exists()) {
                buildPropertiesFileTxt.createNewFile();
            }
            FileOutputStream textOut = new FileOutputStream(buildPropertiesFileTxt);
            allBuildProperties.store(textOut, null);
            textOut.close();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error while creating 'metadata' files", ex);
        }
    }

    private static String getMD5(File outputZipFile) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        FileInputStream zipIs = new FileInputStream(outputZipFile);
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = ((InputStream)zipIs).read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        String computedMD5 = bigInt.toString(16);
        ((InputStream)zipIs).close();
        return computedMD5;
    }
}

