/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Mojo(name="generate-composite-site", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=false)
public class GenerateCompositeSite
extends AbstractTychoPackagingMojo {
    @Parameter(property="project", required=false, readonly=false)
    private MavenProject project;
    @Parameter(property="generate-composite-site.childSites")
    private String childSites;
    @Parameter(property="generate-composite-site.compositeSiteFolder", defaultValue="composite")
    private String compositeSiteFolder = "composite";
    @Parameter(property="generate-composite-site.compositeSiteName")
    private String compositeSiteName;
    @Parameter(property="generate-composite-site.collectChildrenFromRemoteURL")
    private String collectChildrenFromRemoteURL;
    @Parameter(property="generate-composite-site.collectChildrenFromRemoteRegex")
    private String collectChildrenFromRemoteRegex = null;
    @Parameter(property="generate-composite-site.collectChildrenFromRemoteLimit", defaultValue="-1")
    private int collectChildrenFromRemoteLimit = -1;

    public void execute() throws MojoFailureException {
        File outputRepository = new File(this.project.getBuild().getDirectory().equals("${project.basedir}/target") ? "target" : this.project.getBuild().getDirectory(), this.compositeSiteFolder);
        ArrayList<String> childSitesList = this.childSites != null ? new ArrayList<String>(Arrays.asList(this.childSites.split("[\\s\t\n\r]+"))) : new ArrayList();
        ArrayList<String> collectChildrenFromRemoteURLList = this.collectChildrenFromRemoteURL != null ? new ArrayList<String>(Arrays.asList(this.collectChildrenFromRemoteURL.split("[\\s\t\n\r]+"))) : new ArrayList();
        for (String site : collectChildrenFromRemoteURLList) {
            this.collectChildrenFromRemote(site, this.collectChildrenFromRemoteRegex, this.collectChildrenFromRemoteLimit, childSitesList);
        }
        try {
            this.createCompositeReferences(outputRepository, childSitesList);
        }
        catch (IOException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void collectChildrenFromRemote(String collectChildrenFromRemoteURL2, String collectChildrenFromRemoteRegex2, int collectChildrenFromRemoteLimit2, List<String> childSitesList2) throws MojoFailureException {
        Document doc = null;
        try {
            doc = Jsoup.connect((String)collectChildrenFromRemoteURL2).get();
            Elements links = doc.getElementsByTag("a");
            Collections.sort(links, new Comparator<Element>(){

                @Override
                public int compare(Element e1, Element e2) {
                    return e2.attr("href").compareTo(e1.attr("href"));
                }
            });
            int linksAdded = 0;
            for (Element link : links) {
                String linkHref = link.attr("href");
                if (collectChildrenFromRemoteRegex2 != null && (!linkHref.matches(collectChildrenFromRemoteRegex2) || linksAdded >= collectChildrenFromRemoteLimit2 && collectChildrenFromRemoteLimit2 >= 0)) continue;
                this.getLog().debug((CharSequence)("Adding: " + linkHref));
                childSitesList2.add(collectChildrenFromRemoteURL2 + linkHref);
                ++linksAdded;
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
        doc = null;
    }

    private void createCompositeReferences(File outputRepository, List<String> childSitesList2) throws IOException {
        long timestamp = System.currentTimeMillis();
        String repoName = this.compositeSiteName;
        if (repoName == null || repoName.equals("")) {
            repoName = this.project.getName();
        }
        if (repoName == null || repoName.equals("")) {
            repoName = this.project.getArtifactId();
        }
        outputRepository.mkdirs();
        File compositeContentXml = new File(outputRepository, "compositeContent.xml");
        StringBuilder compositeContent = new StringBuilder();
        compositeContent.append("<?compositeMetadataRepository version='1.0.0'?>").append('\n').append("<repository name='").append(repoName).append("' type='org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository' version='1.0.0'>").append('\n').append("  <properties size='2'>").append('\n').append("    <property name='p2.compressed' value='true'/>").append('\n').append("    <property name='p2.timestamp' value='").append(timestamp).append("'/>").append('\n').append("  </properties>").append("\n").append("  <children size='").append(childSitesList2.size()).append("'>").append("\n");
        for (String site : childSitesList2) {
            compositeContent.append("    <child location='").append(site).append("'/>").append('\n');
        }
        compositeContent.append("  </children>").append('\n').append("</repository>\n\n");
        FileUtils.writeStringToFile((File)compositeContentXml, (String)compositeContent.toString());
        File compositeArtifactsXml = new File(outputRepository, "compositeArtifacts.xml");
        StringBuilder compositeArtifact = new StringBuilder();
        compositeArtifact.append("<?compositeArtifactRepository version='1.0.0'?>").append('\n').append("<repository name='").append(repoName).append("' type='org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository' version='1.0.0'>").append('\n').append("  <properties size='2'>").append('\n').append("    <property name='p2.compressed' value='true'/>").append('\n').append("    <property name='p2.timestamp' value='").append(timestamp).append("'/>").append('\n').append("  </properties>").append("\n").append("  <children size='").append(childSitesList2.size()).append("'>").append("\n");
        for (String site : childSitesList2) {
            compositeArtifact.append("    <child location='").append(site).append("'/>").append('\n');
        }
        compositeArtifact.append("  </children>").append('\n').append("</repository>\n\n");
        FileUtils.writeStringToFile((File)compositeArtifactsXml, (String)compositeArtifact.toString());
        File compositeP2Index = new File(outputRepository, "p2.index");
        StringBuilder p2Index = new StringBuilder();
        p2Index.append("version = 1").append('\n').append("metadata.repository.factory.order = compositeContent.xml,\\!").append('\n').append("artifact.repository.factory.order = compositeArtifacts.xml,\\!").append('\n');
        FileUtils.writeStringToFile((File)compositeP2Index, (String)p2Index.toString());
        this.getLog().info((CharSequence)("Composite site '" + repoName + "' with " + childSitesList2.size() + " child sites written to:"));
        this.getLog().info((CharSequence)outputRepository.toPath().toAbsolutePath().toString());
    }
}

