/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.weld.module.web.logging.ServletLogger;
import org.jboss.weld.module.web.servlet.ServletContextService;

public class ServletLogger_$logger
extends DelegatingBasicLogger
implements ServletLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServletLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ServletLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String onlyHttpServletLifecycleDefined$str() {
        return "WELD-000707: Non Http-Servlet lifecycle not defined";
    }

    @Override
    public final IllegalStateException onlyHttpServletLifecycleDefined() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.onlyHttpServletLifecycleDefined$str(), new Object[0]));
        ServletLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void requestInitialized(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.requestInitialized$str(), param1);
    }

    protected String requestInitialized$str() {
        return "WELD-000708: Initializing request {0}";
    }

    @Override
    public final void requestDestroyed(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.requestDestroyed$str(), param1);
    }

    protected String requestDestroyed$str() {
        return "WELD-000709: Destroying request {0}";
    }

    protected String cannotInjectObjectOutsideOfServletRequest$str() {
        return "WELD-000710: Cannot inject {0} outside of a Servlet request";
    }

    @Override
    public final IllegalStateException cannotInjectObjectOutsideOfServletRequest(Object param1, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.cannotInjectObjectOutsideOfServletRequest$str(), param1), cause);
        ServletLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    @Override
    public final void webXmlMappingPatternIgnored(String pattern) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.webXmlMappingPatternIgnored$str(), (Object)pattern);
    }

    protected String webXmlMappingPatternIgnored$str() {
        return "WELD-000711: Context activation pattern {0} ignored as it is overriden by the integrator.";
    }

    @Override
    public final void unableToDissociateContext(Object context, Object storage) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToDissociateContext$str(), context, storage);
    }

    protected String unableToDissociateContext$str() {
        return "WELD-000712: Unable to dissociate context {0} from the storage {1}";
    }

    protected String cannotInjectServletContext$str() {
        return "WELD-000713: Unable to inject ServletContext. None is associated with {0}, {1}";
    }

    @Override
    public final IllegalStateException cannotInjectServletContext(ClassLoader classLoader, ServletContextService service) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.cannotInjectServletContext$str(), classLoader, service));
        ServletLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void guardLeak(int value) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.guardLeak$str(), (Object)value);
    }

    protected String guardLeak$str() {
        return "WELD-000714: HttpContextLifecycle guard leak detected. The Servlet container is not fully compliant. The value was {0}";
    }

    @Override
    public final void guardNotSet() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.guardNotSet$str(), new Object[0]);
    }

    protected String guardNotSet$str() {
        return "WELD-000715: HttpContextLifecycle guard not set. The Servlet container is not fully compliant.";
    }

    @Override
    public final void servlet2Environment() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.servlet2Environment$str(), new Object[0]);
    }

    protected String servlet2Environment$str() {
        return "WELD-000716: Running in Servlet 2.x environment. Asynchronous request support is disabled.";
    }

    @Override
    public final void unableToDeactivateContext(Object context, Object request) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToDeactivateContext$str(), context, request);
    }

    protected String unableToDeactivateContext$str() {
        return "WELD-000717: Unable to deactivate context {0} when destroying request {1}";
    }

    @Override
    public final void noEeModuleDescriptor(Object beanArchiveId) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noEeModuleDescriptor$str(), beanArchiveId);
    }

    protected String noEeModuleDescriptor$str() {
        return "WELD-000718: No EEModuleDescriptor defined for bean archive with ID: {0}. @Initialized and @Destroyed events for ApplicationScoped may be fired twice.";
    }

    public final void catchingDebug(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, arg0, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

