/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.servlet;

import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.contexts.AbstractConversationContext;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.web.context.http.LazyHttpConversationContextImpl;
import org.jboss.weld.module.web.logging.ServletLogger;
import org.jboss.weld.util.reflection.Reflections;

public class ConversationContextActivator {
    private static final String NO_CID = "nocid";
    private static final String CONVERSATION_PROPAGATION = "conversationPropagation";
    private static final String CONVERSATION_PROPAGATION_NONE = "none";
    private static final String CONTEXT_ACTIVATED_IN_REQUEST = ConversationContextActivator.class.getName() + ".contextActivatedInRequest";
    private final BeanManagerImpl beanManager;
    private HttpConversationContext httpConversationContextCache;
    private final FastEvent<HttpServletRequest> conversationInitializedEvent;
    private final FastEvent<HttpServletRequest> conversationBeforeDestroyedEvent;
    private final FastEvent<HttpServletRequest> conversationDestroyedEvent;
    private final Consumer<HttpServletRequest> lazyInitializationCallback;
    private final boolean lazy;

    protected ConversationContextActivator(BeanManagerImpl beanManager, boolean lazy) {
        this.beanManager = beanManager;
        this.conversationInitializedEvent = FastEvent.of(HttpServletRequest.class, (BeanManagerImpl)beanManager, (Annotation[])new Annotation[]{Initialized.Literal.CONVERSATION});
        this.conversationBeforeDestroyedEvent = FastEvent.of(HttpServletRequest.class, (BeanManagerImpl)beanManager, (Annotation[])new Annotation[]{BeforeDestroyed.Literal.CONVERSATION});
        this.conversationDestroyedEvent = FastEvent.of(HttpServletRequest.class, (BeanManagerImpl)beanManager, (Annotation[])new Annotation[]{Destroyed.Literal.CONVERSATION});
        this.lazyInitializationCallback = lazy ? arg_0 -> this.conversationInitializedEvent.fire(arg_0) : null;
        this.lazy = lazy;
    }

    private HttpConversationContext httpConversationContext() {
        if (this.httpConversationContextCache == null) {
            this.httpConversationContextCache = (HttpConversationContext)this.beanManager.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.httpConversationContextCache;
    }

    public void startConversationContext(HttpServletRequest request) {
        this.associateConversationContext(request);
        this.activateConversationContext(request);
    }

    public void stopConversationContext(HttpServletRequest request) {
        this.deactivateConversationContext(request);
    }

    protected void activateConversationContext(HttpServletRequest request) {
        HttpConversationContext conversationContext = this.httpConversationContext();
        if (!this.isContextActivatedInRequest(request)) {
            this.setContextActivatedInRequest(request);
            this.activate(conversationContext, request);
        } else {
            conversationContext.dissociate((Object)request);
            conversationContext.associate((Object)request);
            this.activate(conversationContext, request);
        }
    }

    private void activate(HttpConversationContext conversationContext, HttpServletRequest request) {
        if (this.lazy) {
            conversationContext.activateLazily(this.lazyInitializationCallback);
        } else {
            String cid = ConversationContextActivator.determineConversationId(request, conversationContext.getParameterName());
            conversationContext.activate(cid);
            if (cid == null) {
                this.conversationInitializedEvent.fire((Object)request);
            }
        }
    }

    protected void associateConversationContext(HttpServletRequest request) {
        this.httpConversationContext().associate((Object)request);
    }

    private void setContextActivatedInRequest(HttpServletRequest request) {
        request.setAttribute(CONTEXT_ACTIVATED_IN_REQUEST, (Object)true);
    }

    private boolean isContextActivatedInRequest(HttpServletRequest request) {
        Object result = request.getAttribute(CONTEXT_ACTIVATED_IN_REQUEST);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    protected void deactivateConversationContext(HttpServletRequest request) {
        try {
            HttpConversationContext conversationContext = this.httpConversationContext();
            if (conversationContext.isActive()) {
                LazyHttpConversationContextImpl lazyConversationContext;
                if (conversationContext instanceof LazyHttpConversationContextImpl && !(lazyConversationContext = (LazyHttpConversationContextImpl)conversationContext).isInitialized()) {
                    lazyConversationContext.deactivate();
                    this.processDestructionQueue(request);
                    return;
                }
                boolean isTransient = conversationContext.getCurrentConversation().isTransient();
                if (ConversationLogger.LOG.isTraceEnabled()) {
                    if (isTransient) {
                        ConversationLogger.LOG.cleaningUpTransientConversation();
                    } else {
                        ConversationLogger.LOG.cleaningUpConversation((Object)conversationContext.getCurrentConversation().getId());
                    }
                }
                if (isTransient) {
                    this.conversationBeforeDestroyedEvent.fire((Object)request);
                }
                conversationContext.invalidate();
                conversationContext.deactivate();
                if (isTransient) {
                    this.conversationDestroyedEvent.fire((Object)request);
                }
                this.processDestructionQueue(request);
            }
        }
        catch (Exception e) {
            ServletLogger.LOG.unableToDeactivateContext(this.httpConversationContext(), request);
            ServletLogger.LOG.catchingDebug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDestructionQueue(HttpServletRequest request) {
        Object contextsAttribute = request.getAttribute(AbstractConversationContext.DESTRUCTION_QUEUE_ATTRIBUTE_NAME);
        if (contextsAttribute instanceof Map) {
            Map contexts;
            Map map = contexts = (Map)Reflections.cast((Object)contextsAttribute);
            synchronized (map) {
                FastEvent beforeDestroyedEvent = FastEvent.of(String.class, (BeanManagerImpl)this.beanManager, (Annotation[])new Annotation[]{BeforeDestroyed.Literal.CONVERSATION});
                FastEvent destroyedEvent = FastEvent.of(String.class, (BeanManagerImpl)this.beanManager, (Annotation[])new Annotation[]{Destroyed.Literal.CONVERSATION});
                Iterator iterator = contexts.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    beforeDestroyedEvent.fire(entry.getKey());
                    for (ContextualInstance contextualInstance : (List)entry.getValue()) {
                        this.destroyContextualInstance(contextualInstance);
                    }
                    destroyedEvent.fire(entry.getKey());
                    iterator.remove();
                }
            }
        }
    }

    private <T> void destroyContextualInstance(ContextualInstance<T> instance) {
        instance.getContextual().destroy(instance.getInstance(), instance.getCreationalContext());
        ContextLogger.LOG.contextualInstanceRemoved(instance, (Object)this);
    }

    protected void disassociateConversationContext(HttpServletRequest request) {
        try {
            this.httpConversationContext().dissociate((Object)request);
        }
        catch (Exception e) {
            ServletLogger.LOG.unableToDissociateContext(this.httpConversationContext(), request);
            ServletLogger.LOG.catchingDebug(e);
        }
    }

    public void sessionCreated(HttpSession session) {
        HttpConversationContext httpConversationContext = this.httpConversationContext();
        if (httpConversationContext instanceof AbstractConversationContext) {
            AbstractConversationContext abstractConversationContext = (AbstractConversationContext)httpConversationContext;
            abstractConversationContext.sessionCreated();
        }
    }

    public static String determineConversationId(HttpServletRequest request, String parameterName) {
        if (request == null) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
        }
        if (request.getParameter(NO_CID) != null) {
            return null;
        }
        if (CONVERSATION_PROPAGATION_NONE.equals(request.getParameter(CONVERSATION_PROPAGATION))) {
            return null;
        }
        String cidName = parameterName;
        String cid = request.getParameter(cidName);
        ConversationLogger.LOG.foundConversationFromRequest((Object)cid);
        return cid;
    }
}

