/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.inject.spi.Bean;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.ClassHierarchyComparator;
import org.jboss.weld.bean.proxy.DefaultBytecodeMethodResolver;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bytecode.Boxing;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.ClassFileUtils;
import org.jboss.weld.util.bytecode.ConstructorUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.JumpMarker;
import org.jboss.weld.util.bytecode.JumpUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.MethodUtils;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory<T> {
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    public static final String PROXY_SUFFIX = "$Proxy$";
    public static final String DEFAULT_PROXY_PACKAGE = "org.jboss.weld.proxies";
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new LinkedHashSet();
    private final ClassLoader classLoader;
    private final String baseProxyName;
    private final Bean<?> bean;
    public static final String CONSTRUCTED_FLAG_NAME = "constructed";
    protected static final BytecodeMethodResolver DEFAULT_METHOD_RESOLVER = new DefaultBytecodeMethodResolver();

    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        this(proxiedBeanType, typeClosure, ProxyFactory.getProxyName(proxiedBeanType, typeClosure, bean), bean);
    }

    /*
     * WARNING - void declaration
     */
    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean) {
        void var6_10;
        Class clazz;
        this.bean = bean;
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        Class<?> clazz2 = typeInfo.getSuperClass();
        Class clazz3 = clazz = clazz2 == null ? Object.class : clazz2;
        if (clazz.equals(Object.class) && this.additionalInterfaces.isEmpty()) {
            Class<?> clazz4 = proxiedBeanType;
        }
        this.beanType = var6_10;
        this.addDefaultAdditionalInterfaces();
        this.baseProxyName = proxyName;
        this.classLoader = ProxyFactory.resolveClassLoaderForBeanProxy(bean, typeInfo);
        ArrayList list = new ArrayList(this.additionalInterfaces);
        Collections.sort(list, ClassHierarchyComparator.INSTANCE);
        this.additionalInterfaces.clear();
        this.additionalInterfaces.addAll(list);
    }

    static String getProxyName(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        String className;
        String proxyPackage;
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            proxyPackage = DEFAULT_PROXY_PACKAGE;
        } else {
            proxyPackage = proxiedBeanType.getPackage() == null ? DEFAULT_PROXY_PACKAGE : proxiedBeanType.getPackage().getName();
        }
        if (typeInfo.getSuperClass() == Object.class) {
            StringBuilder name = new StringBuilder();
            className = ProxyFactory.createCompoundProxyName(bean, typeInfo, name) + PROXY_SUFFIX;
        } else {
            boolean typeModified = false;
            for (Class<?> iface : typeInfo.getInterfaces()) {
                if (iface.isAssignableFrom(typeInfo.getSuperClass())) continue;
                typeModified = true;
                break;
            }
            if (typeModified) {
                StringBuilder name = new StringBuilder(typeInfo.getSuperClass().getSimpleName() + "$");
                className = ProxyFactory.createCompoundProxyName(bean, typeInfo, name) + PROXY_SUFFIX;
            } else {
                className = typeInfo.getSuperClass().getSimpleName() + PROXY_SUFFIX;
            }
        }
        return proxyPackage + '.' + className;
    }

    private static String createCompoundProxyName(Bean<?> bean, Proxies.TypeInfo typeInfo, StringBuilder name) {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> type : typeInfo.getInterfaces()) {
            interfaces.add(type.getSimpleName());
        }
        Collections.sort(interfaces);
        for (String iface : interfaces) {
            name.append(iface);
            name.append('$');
        }
        String id = Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
        name.append(id.hashCode());
        String className = name.toString();
        return className;
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy = null;
        Class<T> proxyClass = this.getProxyClass();
        try {
            proxy = InstantiatorFactory.useInstantiators() ? (T)SecureReflections.newUnsafeInstance(proxyClass) : (T)SecureReflections.newInstance(proxyClass);
        }
        catch (InstantiationException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        ((ProxyObject)proxy).setHandler(new ProxyMethodHandler(beanInstance, this.bean));
        return proxy;
    }

    public Class<T> getProxyClass() {
        String suffix = "_$$_Weld" + this.getProxyNameSuffix();
        String proxyClassName = this.getBaseProxyName();
        if (!proxyClassName.endsWith(suffix)) {
            proxyClassName = proxyClassName + suffix;
        }
        if (proxyClassName.startsWith("java")) {
            proxyClassName = proxyClassName.replaceFirst("java", "org.jboss.weld");
        }
        Class<T> proxyClass = null;
        log.trace("Retrieving/generating proxy class " + proxyClassName);
        try {
            proxyClass = (Class<T>)Reflections.cast(this.classLoader.loadClass(proxyClassName));
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(proxyClassName);
            }
            catch (Exception e1) {
                throw new WeldException(e1);
            }
        }
        return proxyClass;
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    public static boolean isProxy(Object proxySuspect) {
        return proxySuspect instanceof ProxyObject;
    }

    public static <T> void setBeanInstance(T proxy, BeanInstance beanInstance, Bean<?> bean) {
        if (proxy instanceof ProxyObject) {
            ProxyObject proxyView = (ProxyObject)proxy;
            proxyView.setHandler(new ProxyMethodHandler(beanInstance, bean));
        }
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
    }

    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
    }

    private Class<T> createProxyClass(String proxyClassName) throws Exception {
        ArraySet specialInterfaces = new ArraySet(3);
        specialInterfaces.add(LifecycleMixin.class);
        specialInterfaces.add(TargetInstanceProxy.class);
        specialInterfaces.add(ProxyObject.class);
        this.addAdditionalInterfaces(specialInterfaces);
        this.additionalInterfaces.removeAll(specialInterfaces);
        ClassFile proxyClassType = null;
        if (this.beanType.isInterface()) {
            proxyClassType = new ClassFile(false, proxyClassName, Object.class.getName());
            proxyClassType.addInterface(this.beanType.getName());
        } else {
            proxyClassType = new ClassFile(false, proxyClassName, this.beanType.getName());
        }
        proxyClassType.setVersionToJava5();
        proxyClassType.setAccessFlags(1);
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        Bytecode initialValueBytecode = new Bytecode(proxyClassType.getConstPool());
        this.addFields(proxyClassType, initialValueBytecode);
        this.addConstructors(proxyClassType, initialValueBytecode);
        this.addMethods(proxyClassType);
        for (Class<?> specialInterface : specialInterfaces) {
            proxyClassType.addInterface(specialInterface.getName());
        }
        ProtectionDomain domain = this.beanType.getProtectionDomain();
        if (this.beanType.isInterface() || this.beanType.equals(Object.class)) {
            domain = ProxyFactory.class.getProtectionDomain();
        }
        Class proxyClass = (Class)Reflections.cast(ClassFileUtils.toClass(proxyClassType, this.classLoader, domain));
        log.trace("Created Proxy class of type " + proxyClass + " supporting interfaces " + Arrays.toString(proxyClass.getInterfaces()));
        return proxyClass;
    }

    protected void addConstructors(ClassFile proxyClassType, Bytecode initialValueBytecode) {
        try {
            if (this.beanType.isInterface()) {
                ConstructorUtils.addDefaultConstructor(proxyClassType, initialValueBytecode);
            } else {
                boolean constructorFound = false;
                for (Constructor<?> constructor : this.beanType.getDeclaredConstructors()) {
                    if ((constructor.getModifiers() & 2) != 0) continue;
                    constructorFound = true;
                    String[] exceptions = new String[constructor.getExceptionTypes().length];
                    for (int i = 0; i < exceptions.length; ++i) {
                        exceptions[i] = constructor.getExceptionTypes()[i].getName();
                    }
                    ConstructorUtils.addConstructor(DescriptorUtils.getConstructorDescriptor(constructor), exceptions, proxyClassType, initialValueBytecode);
                }
                if (!constructorFound) {
                    this.addConstructorsForBeanWithPrivateConstructors(proxyClassType);
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(ClassFile proxyClassType, Bytecode initialValueBytecode) {
        try {
            proxyClassType.addField(new FieldInfo(proxyClassType.getConstPool(), "methodHandler", "Ljavassist/util/proxy/MethodHandler;"));
            FieldInfo constfield = new FieldInfo(proxyClassType.getConstPool(), CONSTRUCTED_FLAG_NAME, "Z");
            constfield.setAccessFlags(2);
            proxyClassType.addField(constfield);
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addMethods(ClassFile proxyClassType) {
        this.addMethodsFromClass(proxyClassType);
        this.addSpecialMethods(proxyClassType);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(ClassFile proxyClassType) {
    }

    protected void addMethodsFromClass(ClassFile proxyClassType) {
        try {
            MethodInfo hashCodeMethod;
            Class<?> cls = this.beanType;
            MethodInfo equalsMethod = this.generateEqualsMethod(proxyClassType);
            if (equalsMethod != null) {
                proxyClassType.addMethod(equalsMethod);
            }
            if ((hashCodeMethod = this.generateHashCodeMethod(proxyClassType)) != null) {
                proxyClassType.addMethod(hashCodeMethod);
            }
            while (cls != null) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || method.getDeclaringClass() == Object.class && !method.getName().equals("toString")) continue;
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        proxyClassType.addMethod(MethodUtils.makeMethod(methodInfo, method.getExceptionTypes(), this.addConstructedGuardToMethodBody(proxyClassType, this.createForwardingMethodBody(proxyClassType, methodInfo), methodInfo), proxyClassType.getConstPool()));
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
                cls = cls.getSuperclass();
            }
            for (Class<?> c : this.additionalInterfaces) {
                for (Method method : c.getMethods()) {
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        proxyClassType.addMethod(MethodUtils.makeMethod(methodInfo, method.getExceptionTypes(), this.createSpecialMethodBody(proxyClassType, methodInfo), proxyClassType.getConstPool()));
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected MethodInfo generateHashCodeMethod(ClassFile proxyClassType) {
        return null;
    }

    protected MethodInfo generateEqualsMethod(ClassFile proxyClassType) {
        return null;
    }

    protected Bytecode createSpecialMethodBody(ClassFile proxyClassType, MethodInformation method) throws NotFoundException {
        return this.createInterceptorBody(proxyClassType, method);
    }

    protected Bytecode addConstructedGuardToMethodBody(ClassFile proxyClassType, Bytecode existingMethod, MethodInformation method) {
        byte[] methodBodyBytes;
        String methodDescriptor = method.getDescriptor();
        Bytecode cond = new Bytecode(proxyClassType.getConstPool());
        cond.add(42);
        cond.addGetfield(proxyClassType.getName(), CONSTRUCTED_FLAG_NAME, "Z");
        cond.add(154);
        JumpMarker invokeSpecial = JumpUtils.addJumpInstruction(cond);
        cond.add(42);
        BytecodeUtils.loadParameters(cond, methodDescriptor);
        cond.addInvokespecial(proxyClassType.getSuperclass(), method.getName(), methodDescriptor);
        BytecodeUtils.addReturnInstruction(cond, method.getReturnType());
        invokeSpecial.mark();
        int offset = cond.currentPc();
        for (byte methodBodyByte : methodBodyBytes = existingMethod.get()) {
            cond.add(methodBodyByte);
        }
        ExceptionTable originalExceptionTable = existingMethod.getExceptionTable();
        if (originalExceptionTable.size() > 0) {
            for (int i = 0; i < originalExceptionTable.size(); ++i) {
                cond.addExceptionHandler(originalExceptionTable.startPc(i) + offset, originalExceptionTable.endPc(i) + offset, originalExceptionTable.handlerPc(i) + offset, originalExceptionTable.catchType(i));
            }
        }
        cond.setMaxLocals(existingMethod.getMaxLocals());
        cond.setMaxStack(existingMethod.getMaxStack());
        return cond;
    }

    protected Bytecode createForwardingMethodBody(ClassFile proxyClassType, MethodInformation method) throws NotFoundException {
        return this.createInterceptorBody(proxyClassType, method);
    }

    protected Bytecode createInterceptorBody(ClassFile file, MethodInformation method) throws NotFoundException {
        Bytecode b = new Bytecode(file.getConstPool());
        ProxyFactory.invokeMethodHandler(file, b, method, true, DEFAULT_METHOD_RESOLVER);
        return b;
    }

    protected static void invokeMethodHandler(ClassFile file, Bytecode b, MethodInformation method, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver) {
        b.add(42);
        b.addGetfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(42);
        bytecodeMethodResolver.getDeclaredMethod(file, b, method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        b.add(1);
        b.addIconst(method.getParameterTypes().length);
        b.addAnewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = method.getParameterTypes()[i];
            b.add(89);
            b.addIconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary(b, typeString);
            b.add(83);
            if (DescriptorUtils.isWide(typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        if (addReturnInstruction) {
            if (method.getReturnType().equals("V")) {
                b.add(177);
            } else if (DescriptorUtils.isPrimitive(method.getReturnType())) {
                Boxing.unbox(b, method.getReturnType());
                if (method.getReturnType().equals("D")) {
                    b.add(175);
                } else if (method.getReturnType().equals("F")) {
                    b.add(174);
                } else if (method.getReturnType().equals("J")) {
                    b.add(173);
                } else {
                    b.add(172);
                }
            } else {
                String castType = method.getReturnType();
                if (!method.getReturnType().startsWith("[")) {
                    castType = method.getReturnType().substring(1).substring(0, method.getReturnType().length() - 2);
                }
                b.addCheckcast(castType);
                b.add(176);
            }
            if (b.getMaxLocals() < localVariableCount) {
                b.setMaxLocals(localVariableCount);
            }
        }
    }

    protected void addSpecialMethods(ClassFile proxyClassType) {
        try {
            for (Method method : LifecycleMixin.class.getDeclaredMethods()) {
                log.trace("Adding method " + method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                proxyClassType.addMethod(MethodUtils.makeMethod(methodInfo, method.getExceptionTypes(), this.createInterceptorBody(proxyClassType, methodInfo), proxyClassType.getConstPool()));
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetClass", new Class[0]);
            RuntimeMethodInformation getInstanceMethodInfo = new RuntimeMethodInformation(getInstanceMethod);
            proxyClassType.addMethod(MethodUtils.makeMethod(getInstanceMethodInfo, getInstanceMethod.getExceptionTypes(), this.createInterceptorBody(proxyClassType, getInstanceMethodInfo), proxyClassType.getConstPool()));
            RuntimeMethodInformation getInstanceClassMethodInfo = new RuntimeMethodInformation(getInstanceClassMethod);
            proxyClassType.addMethod(MethodUtils.makeMethod(getInstanceClassMethodInfo, getInstanceClassMethod.getExceptionTypes(), this.createInterceptorBody(proxyClassType, getInstanceClassMethodInfo), proxyClassType.getConstPool()));
            Method setMethodHandlerMethod = ProxyObject.class.getDeclaredMethod("setHandler", MethodHandler.class);
            RuntimeMethodInformation setMethodHandlerMethodInfo = new RuntimeMethodInformation(setMethodHandlerMethod);
            proxyClassType.addMethod(MethodUtils.makeMethod(setMethodHandlerMethodInfo, setMethodHandlerMethod.getExceptionTypes(), ProxyFactory.generateSetMethodHandlerBody(proxyClassType), proxyClassType.getConstPool()));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private static Bytecode generateSetMethodHandlerBody(ClassFile file) {
        Bytecode b = new Bytecode(file.getConstPool(), 3, 2);
        b.add(42);
        b.add(43);
        b.addPutfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(177);
        return b;
    }

    private void addConstructorsForBeanWithPrivateConstructors(ClassFile proxyClassType) {
        try {
            MethodInfo ctor = new MethodInfo(proxyClassType.getConstPool(), "<init>", "(Ljava/lang/Byte;)V");
            Bytecode b = new Bytecode(proxyClassType.getConstPool(), 3, 3);
            b.add(42);
            b.add(1);
            b.add(1);
            b.addInvokespecial(proxyClassType.getName(), "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;)V");
            b.add(177);
            ctor.setCodeAttribute(b.toCodeAttribute());
            ctor.setAccessFlags(1);
            proxyClassType.addMethod(ctor);
            ctor = new MethodInfo(proxyClassType.getConstPool(), "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;)V");
            b = new Bytecode(proxyClassType.getConstPool(), 3, 3);
            b.add(42);
            b.add(1);
            b.addInvokespecial(proxyClassType.getName(), "<init>", "(Ljava/lang/Byte;)V");
            b.add(177);
            ctor.setCodeAttribute(b.toCodeAttribute());
            ctor.setAccessFlags(1);
            proxyClassType.addMethod(ctor);
        }
        catch (DuplicateMemberException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public static ClassLoader resolveClassLoaderForBeanProxy(Bean<?> bean, Proxies.TypeInfo typeInfo) {
        Class<?> superClass = typeInfo.getSuperClass();
        if (superClass.getName().startsWith("java")) {
            ClassLoader cl = Container.instance().services().get(ProxyServices.class).getClassLoader(bean.getBeanClass());
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return cl;
        }
        return Container.instance().services().get(ProxyServices.class).getClassLoader(superClass);
    }

    public static ClassLoader resolveClassLoaderForBeanProxy(Bean<?> bean) {
        return ProxyFactory.resolveClassLoaderForBeanProxy(bean, Proxies.TypeInfo.of(bean.getTypes()));
    }
}

