/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bean.builtin.ee.StaticEEResourceProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessBeanAttributesImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private final BeanManagerImpl manager;
    private final ServiceRegistry services;
    private final E environment;
    protected final ContainerLifecycleEvents containerLifecycleEvents;
    protected final ClassTransformer classTransformer;
    protected final SlimAnnotatedTypeStore slimAnnotatedTypeStore;
    protected final SpecializationAndEnablementRegistry specializationAndEnablementRegistry;

    public AbstractBeanDeployer(BeanManagerImpl manager, ServiceRegistry services, E environment) {
        this.manager = manager;
        this.services = services;
        this.environment = environment;
        this.containerLifecycleEvents = manager.getServices().get(ContainerLifecycleEvents.class);
        this.classTransformer = services.get(ClassTransformer.class);
        this.slimAnnotatedTypeStore = services.get(SlimAnnotatedTypeStore.class);
        this.specializationAndEnablementRegistry = services.get(SpecializationAndEnablementRegistry.class);
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public AbstractBeanDeployer<E> deploySpecialized() {
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), decoratorImpl);
            this.manager.addDecorator(decoratorImpl);
            BootstrapLogger.LOG.foundDecorator(decoratorImpl);
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), interceptorImpl);
            this.manager.addInterceptor(interceptorImpl);
            BootstrapLogger.LOG.foundInterceptor(interceptorImpl);
        }
        return this;
    }

    public AbstractBeanDeployer<E> initializeBeans() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            bean.initialize((BeanDeployerEnvironment)this.getEnvironment());
        }
        return this;
    }

    public AbstractBeanDeployer<E> fireBeanEvents() {
        for (RIBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getBeans()) {
            this.fireBeanEvents(bean);
        }
        return this;
    }

    public void fireBeanEvents(RIBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            if (bean instanceof AbstractProducerBean) {
                this.containerLifecycleEvents.fireProcessProducer(this.manager, (AbstractProducerBean)Reflections.cast(bean));
            } else if (bean instanceof AbstractClassBean) {
                this.containerLifecycleEvents.fireProcessInjectionTarget(this.manager, (AbstractClassBean)bean);
            }
            this.containerLifecycleEvents.fireProcessBean(this.getManager(), bean);
        }
    }

    public AbstractBeanDeployer<E> deployBeans() {
        this.manager.addBeans(((BeanDeployerEnvironment)this.getEnvironment()).getBeans());
        return this;
    }

    public AbstractBeanDeployer<E> initializeObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            observerInitializer.initialize();
        }
        return this;
    }

    public AbstractBeanDeployer<E> deployObserverMethods() {
        for (ObserverInitializationContext<?, ?> observerInitializer : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerInitializer.getObserver(), this.manager)) continue;
            BootstrapLogger.LOG.foundObserverMethod(observerInitializer.getObserver());
            ProcessObserverMethodImpl.fire(this.manager, observerInitializer.getObserver());
            this.manager.addObserver(observerInitializer.getObserver());
        }
        return this;
    }

    protected <T> void createObserversProducersDisposers(AbstractClassBean<T> bean) {
        if (bean instanceof ManagedBean || bean instanceof SessionBean) {
            this.createDisposalMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            this.createProducerFields((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            if (this.manager.isBeanEnabled(bean)) {
                this.createObserverMethods((AbstractClassBean)bean, (EnhancedAnnotatedType)bean.getEnhancedAnnotated());
            }
        }
    }

    protected <X> DisposalMethod<X, ?> resolveDisposalMethod(BeanAttributes<?> attributes, AbstractClassBean<X> declaringBean) {
        Set<DisposalMethod<X, ?>> disposalBeans = ((BeanDeployerEnvironment)this.environment).resolveDisposalBeans(attributes.getTypes(), attributes.getQualifiers(), declaringBean);
        if (disposalBeans.size() == 1) {
            return disposalBeans.iterator().next();
        }
        if (disposalBeans.size() > 1) {
            throw BeanLogger.LOG.multipleDisposalMethods(this, WeldCollections.toMultiRowString(disposalBeans));
        }
        return null;
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> type) {
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : BeanMethods.filterOutBridgeMethods(type.getDeclaredEnhancedMethods(Produces.class))) {
            this.createProducerMethod(declaringBean, enhancedAnnotatedMethod);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : BeanMethods.filterOutBridgeMethods(annotatedClass.getDeclaredEnhancedMethodsWithAnnotatedParameters(Disposes.class))) {
            DisposalMethod disposalBean = DisposalMethod.of(this.manager, enhancedAnnotatedMethod, declaringBean);
            ((BeanDeployerEnvironment)this.getEnvironment()).addDisposesMethod(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> annotatedMethod) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(annotatedMethod, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        ProducerMethod<X, T> bean = ProducerMethod.of(attributes, annotatedMethod, declaringBean, disposalMethod, this.manager, this.services);
        this.containerLifecycleEvents.preloadProcessBeanAttributes(bean.getType());
        this.containerLifecycleEvents.preloadProcessBean(ProcessProducerMethod.class, annotatedMethod.getBaseType(), bean.getBeanClass());
        this.containerLifecycleEvents.preloadProcessProducer(bean.getBeanClass(), annotatedMethod.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerMethod(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, EnhancedAnnotatedField<T, ? super X> field) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forBean(field, this.getManager());
        DisposalMethod<X, T> disposalMethod = this.resolveDisposalMethod(attributes, declaringBean);
        EEResourceProducerField bean = this.isEEResourceProducerField(field) ? (field.isStatic() ? StaticEEResourceProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services) : EEResourceProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services)) : ProducerField.of(attributes, field, declaringBean, disposalMethod, this.manager, this.services);
        this.containerLifecycleEvents.preloadProcessBeanAttributes(bean.getType());
        this.containerLifecycleEvents.preloadProcessBean(ProcessProducerField.class, field.getBaseType(), bean.getBeanClass());
        this.containerLifecycleEvents.preloadProcessProducer(bean.getBeanClass(), field.getBaseType());
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerField(bean);
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<X> annotatedClass) {
        for (EnhancedAnnotatedField<?, X> field : annotatedClass.getDeclaredEnhancedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(AbstractClassBean<X> declaringBean, EnhancedAnnotatedType<? super X> annotatedClass) {
        for (EnhancedAnnotatedMethod<?, ? super X> enhancedAnnotatedMethod : BeanMethods.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, enhancedAnnotatedMethod);
        }
    }

    protected <T, X> void createObserverMethod(AbstractClassBean<X> declaringBean, EnhancedAnnotatedMethod<T, ? super X> method) {
        ObserverMethodImpl<T, X> observer = ObserverFactory.create(method, declaringBean, this.manager);
        ObserverInitializationContext<T, ? super X> observerInitializer = ObserverInitializationContext.of(observer, method);
        this.containerLifecycleEvents.preloadProcessObserverMethod(observer.getObservedType(), declaringBean.getBeanClass());
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserverMethod(observerInitializer);
    }

    protected <T> ManagedBean<T> createManagedBean(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        ManagedBean bean = ManagedBean.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(bean);
        return bean;
    }

    protected <T> void createNewManagedBean(EnhancedAnnotatedType<T> annotatedClass) {
        this.slimAnnotatedTypeStore.put(annotatedClass.slim());
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(NewManagedBean.of(BeanAttributesFactory.forNewManagedBean(annotatedClass, this.manager), annotatedClass, this.manager));
    }

    protected <T> void createDecorator(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        DecoratorImpl bean = DecoratorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addDecorator(bean);
    }

    protected <T> void createInterceptor(EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes attributes = BeanAttributesFactory.forBean(weldClass, this.getManager());
        InterceptorImpl bean = InterceptorImpl.of(attributes, weldClass, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addInterceptor(bean);
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor) {
        EnhancedAnnotatedType type = this.classTransformer.getEnhancedAnnotatedType(descriptor.getBeanClass(), this.getManager().getId());
        this.slimAnnotatedTypeStore.put(type.slim());
        return this.createSessionBean(descriptor, type);
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor, EnhancedAnnotatedType<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forSessionBean(weldClass, descriptor, this.getManager());
        SessionBean<T> bean = SessionBean.of(attributes, descriptor, this.manager, weldClass);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(bean);
        return bean;
    }

    protected <T> void createNewSessionBean(InternalEjbDescriptor<T> ejbDescriptor, BeanAttributes<?> originalAttributes, EnhancedAnnotatedType<?> type) {
        this.slimAnnotatedTypeStore.put(type.slim());
        BeanAttributes attributes = (BeanAttributes)Reflections.cast(BeanAttributesFactory.forNewSessionBean(originalAttributes, type.getJavaClass()));
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(NewSessionBean.of(attributes, ejbDescriptor, this.manager));
    }

    protected boolean isEEResourceProducerField(EnhancedAnnotatedField<?, ?> field) {
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = this.manager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    public E getEnvironment() {
        return this.environment;
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addBuiltInBean(bean);
    }

    public void addExtension(ExtensionBean bean) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addExtension(bean);
    }

    protected <T, S> boolean fireProcessBeanAttributes(AbstractBean<T, S> bean) {
        if (!this.specializationAndEnablementRegistry.isCandidateForLifecycleEvent(bean)) {
            return false;
        }
        ProcessBeanAttributesImpl event = this.containerLifecycleEvents.fireProcessBeanAttributes(this.getManager(), bean, bean.getAnnotated(), bean.getType());
        if (event == null) {
            return false;
        }
        if (event.isVeto()) {
            return true;
        }
        if (event.isDirty()) {
            bean.setAttributes(ExternalBeanAttributesFactory.of(event.getBeanAttributesInternal(), this.manager));
            bean.checkSpecialization();
        }
        return false;
    }
}

