/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.security.GetDeclaredConstructorAction;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;

public class Proxies {
    private Proxies() {
    }

    public static boolean isTypeProxyable(Type type, ServiceRegistry services) {
        return Proxies.getUnproxyableTypeException(type, services) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypeException(Type type, ServiceRegistry services) {
        return Proxies.getUnproxyableTypeException(type, null, services);
    }

    public static boolean isTypesProxyable(Bean<?> declaringBean, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesException(declaringBean, services) == null;
    }

    public static boolean isTypesProxyable(Iterable<? extends Type> types, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesException(types, services) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Bean<?> declaringBean, ServiceRegistry services) {
        if (declaringBean == null) {
            throw new IllegalArgumentException("Null declaring bean!");
        }
        return Proxies.getUnproxyableTypesExceptionInt(declaringBean.getTypes(), declaringBean, services);
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Iterable<? extends Type> types, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesExceptionInt(types, null, services);
    }

    public static UnproxyableResolutionException getUnproxyableTypeException(Type type, Bean<?> declaringBean, ServiceRegistry services) {
        Type rawType;
        if (type instanceof Class) {
            return Proxies.getUnproxyableClassException((Class)type, declaringBean, services);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return Proxies.getUnproxyableClassException((Class)rawType, declaringBean, services);
        }
        return ValidatorLogger.LOG.notProxyableUnknown(type, Proxies.getDeclaringBeanInfo(declaringBean));
    }

    private static UnproxyableResolutionException getUnproxyableTypesExceptionInt(Iterable<? extends Type> types, Bean<?> declaringBean, ServiceRegistry services) {
        for (Type type : types) {
            UnproxyableResolutionException e;
            if (Object.class.equals((Object)type) || (e = Proxies.getUnproxyableTypeException(type, declaringBean, services)) == null) continue;
            return e;
        }
        return null;
    }

    private static UnproxyableResolutionException getUnproxyableClassException(Class<?> clazz, Bean<?> declaringBean, ServiceRegistry services) {
        Constructor constructor;
        if (clazz.isInterface()) {
            return null;
        }
        try {
            constructor = (Constructor)AccessController.doPrivileged(GetDeclaredConstructorAction.of(clazz, new Class[0]));
        }
        catch (PrivilegedActionException e) {
            InstantiatorFactory factory = services.get(InstantiatorFactory.class);
            if (factory == null || !factory.useInstantiators()) {
                return ValidatorLogger.LOG.notProxyableNoConstructor(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
            }
            return null;
        }
        if (constructor == null) {
            return ValidatorLogger.LOG.notProxyableNoConstructor(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            InstantiatorFactory factory = services.get(InstantiatorFactory.class);
            if (factory == null || !factory.useInstantiators()) {
                return new UnproxyableResolutionException(ValidatorLogger.LOG.notProxyablePrivateConstructor(clazz, constructor, Proxies.getDeclaringBeanInfo(declaringBean)));
            }
            return null;
        }
        if (Reflections.isTypeOrAnyMethodFinal(clazz)) {
            return ValidatorLogger.LOG.notProxyableFinalTypeOrMethod(clazz, Reflections.getNonPrivateFinalMethodOrType(clazz), Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (clazz.isPrimitive()) {
            return ValidatorLogger.LOG.notProxyablePrimitive(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Reflections.isArrayType(clazz)) {
            return ValidatorLogger.LOG.notProxyableArrayType(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        return null;
    }

    private static Object getDeclaringBeanInfo(Bean<?> bean) {
        return bean != null ? bean : "<unknown javax.enterprise.inject.spi.Bean instance>";
    }

    public static class TypeInfo {
        private final Set<Class<?>> interfaces = new LinkedHashSet();
        private final Set<Class<?>> classes = new LinkedHashSet();

        private TypeInfo() {
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                return Object.class;
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        public Class<?> getSuperInterface() {
            if (this.interfaces.isEmpty()) {
                return null;
            }
            Iterator<Class<?>> it = this.interfaces.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        private TypeInfo add(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isInterface()) {
                    this.interfaces.add(clazz);
                } else {
                    this.classes.add(clazz);
                }
            } else if (type instanceof ParameterizedType) {
                this.add(((ParameterizedType)type).getRawType());
            } else {
                throw UtilLogger.LOG.cannotProxyNonClassType(type);
            }
            return this;
        }

        public Set<Class<?>> getClasses() {
            return Collections.unmodifiableSet(this.classes);
        }

        public Set<Class<?>> getInterfaces() {
            return Collections.unmodifiableSet(this.interfaces);
        }

        public static TypeInfo of(Set<? extends Type> types) {
            TypeInfo typeInfo = new TypeInfo();
            for (Type type : types) {
                typeInfo.add(type);
            }
            return typeInfo;
        }
    }
}

