/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;

public class ServletContextBeanArchiveHandler
implements BeanArchiveHandler {
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private final ServletContext servletContext;

    public ServletContextBeanArchiveHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public BeanArchiveBuilder handle(String path) {
        if (!path.equals("/WEB-INF/classes")) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder();
        this.handleResourcePath(path, path, builder);
        return builder;
    }

    private void handleResourcePath(String rootPath, String resourcePath, BeanArchiveBuilder builder) {
        WeldServletLogger.LOG.debugv("Handle resource path: {0}", (Object)resourcePath);
        Set subpaths = this.servletContext.getResourcePaths(resourcePath);
        if (subpaths != null && !subpaths.isEmpty()) {
            for (String subpath : subpaths) {
                if (subpath.endsWith(SLASH)) {
                    this.handleResourcePath(rootPath, subpath, builder);
                    continue;
                }
                if (!subpath.endsWith(".class")) continue;
                String className = this.toClassName(rootPath, subpath);
                builder.addClass(className);
                WeldServletLogger.LOG.tracev("Class discovered: {0}", (Object)className);
            }
        }
    }

    private String toClassName(String rootPath, String resourcePath) {
        return resourcePath.substring(rootPath.length() + 1, resourcePath.lastIndexOf(".class")).replace(SLASH, DOT);
    }
}

