/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

public final class JsseSslUtils {
    private JsseSslUtils() {
    }

    public static SSLContext createSSLContext(OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagers;
        int i;
        int size;
        KeyManager[] keyManagers;
        String provider = optionMap.get(Options.SSL_PROVIDER);
        String protocol = optionMap.get(Options.SSL_PROTOCOL);
        if (protocol == null) {
            return SSLContext.getDefault();
        }
        SSLContext sslContext = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        Sequence<Class<? extends KeyManager>> keyManagerClasses = optionMap.get(Options.SSL_JSSE_KEY_MANAGER_CLASSES);
        Sequence<Class<? extends TrustManager>> trustManagerClasses = optionMap.get(Options.SSL_JSSE_TRUST_MANAGER_CLASSES);
        if (keyManagerClasses == null) {
            keyManagers = null;
        } else {
            size = keyManagerClasses.size();
            keyManagers = new KeyManager[size];
            for (i = 0; i < size; ++i) {
                keyManagers[i] = JsseSslUtils.instantiate(keyManagerClasses.get(i));
            }
        }
        if (trustManagerClasses == null) {
            trustManagers = null;
        } else {
            size = trustManagerClasses.size();
            trustManagers = new TrustManager[size];
            for (i = 0; i < size; ++i) {
                trustManagers[i] = JsseSslUtils.instantiate(trustManagerClasses.get(i));
            }
        }
        sslContext.init(keyManagers, trustManagers, null);
        sslContext.getClientSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_CLIENT_SESSION_CACHE_SIZE, 0));
        sslContext.getClientSessionContext().setSessionTimeout(optionMap.get(Options.SSL_CLIENT_SESSION_TIMEOUT, 0));
        sslContext.getServerSessionContext().setSessionCacheSize(optionMap.get(Options.SSL_SERVER_SESSION_CACHE_SIZE, 0));
        sslContext.getServerSessionContext().setSessionTimeout(optionMap.get(Options.SSL_SERVER_SESSION_TIMEOUT, 0));
        return sslContext;
    }

    private static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate " + clazz, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate " + clazz, e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot instantiate " + clazz, e);
        }
    }

    public static SSLEngine createSSLEngine(SSLContext sslContext, OptionMap optionMap, InetSocketAddress peerAddress, boolean server) {
        Sequence<String> protocols;
        SslClientAuthMode clientAuthMode;
        SSLEngine engine = sslContext.createSSLEngine(peerAddress.getHostName(), peerAddress.getPort());
        boolean clientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, false) ^ !server;
        engine.setUseClientMode(clientMode);
        if (!clientMode && (clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE)) != null) {
            switch (clientAuthMode) {
                case NOT_REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(false);
                    break;
                }
                case REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setWantClientAuth(false);
                    engine.setNeedClientAuth(true);
                }
            }
        }
        engine.setEnableSessionCreation(optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true));
        Sequence<String> cipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : cipherSuites) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS)) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : protocols) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        return engine;
    }
}

