/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelPipe;
import org.xnio.CompressionType;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.LimitedBlockingQueue;
import org.xnio.LocalSocketAddress;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.Channels;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.streams.ChannelInputStream;
import org.xnio.streams.ChannelOutputStream;

public abstract class XnioWorker
extends AbstractExecutorService
implements Configurable,
ExecutorService {
    private final Xnio xnio;
    private final TaskPool taskPool;
    private final String name;
    private final Runnable terminationTask;
    private final AtomicInteger taskSeq = new AtomicInteger(1);
    private static final AtomicInteger seq = new AtomicInteger(1);
    private static Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.WORKER_TASK_CORE_THREADS).add(Options.WORKER_TASK_MAX_THREADS).add(Options.WORKER_TASK_KEEPALIVE).create();

    protected XnioWorker(Xnio xnio, final ThreadGroup threadGroup, final OptionMap optionMap, Runnable terminationTask) {
        this.xnio = xnio;
        this.terminationTask = terminationTask;
        String workerName = optionMap.get(Options.WORKER_NAME);
        if (workerName == null) {
            workerName = "XNIO-" + seq.getAndIncrement();
        }
        this.name = workerName;
        int taskLimit = optionMap.get(Options.WORKER_TASK_LIMIT, 16384);
        final LimitedBlockingQueue<Runnable> taskQueue = new LimitedBlockingQueue<Runnable>(new LinkedBlockingQueue(taskLimit), taskLimit >> 2);
        final boolean markThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        this.taskPool = new TaskPool(optionMap.get(Options.WORKER_TASK_CORE_THREADS, 4), optionMap.get(Options.WORKER_TASK_MAX_THREADS, 16), optionMap.get(Options.WORKER_TASK_KEEPALIVE, 60), TimeUnit.MILLISECONDS, taskQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread taskThread = new Thread(threadGroup, r, XnioWorker.this.name + " task-" + XnioWorker.this.taskSeq.getAndIncrement(), optionMap.get(Options.STACK_SIZE, 0L));
                if (markThreadAsDaemon) {
                    taskThread.setDaemon(true);
                }
                return taskThread;
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!taskQueue.offerUnchecked(r)) {
                    throw new RejectedExecutionException("Task limit exceeded (server may be too busy to handle request)");
                }
            }
        });
    }

    public AcceptingChannel<? extends ConnectedStreamChannel> createStreamServer(SocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (bindAddress instanceof InetSocketAddress) {
            return this.createTcpServer((InetSocketAddress)bindAddress, acceptListener, optionMap);
        }
        if (bindAddress instanceof LocalSocketAddress) {
            return this.createLocalStreamServer((LocalSocketAddress)bindAddress, acceptListener, optionMap);
        }
        throw new UnsupportedOperationException("Unsupported socket address " + bindAddress.getClass());
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("TCP server");
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createLocalStreamServer(LocalSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UNIX stream server");
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, null, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, null, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcpStream((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalStream((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to stream server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> connectTcpStream(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to TCP server");
    }

    protected IoFuture<ConnectedStreamChannel> connectLocalStream(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local stream server");
    }

    public IoFuture<ConnectedStreamChannel> acceptStream(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptTcpStream((InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalStream((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> acceptLocalStream(LocalSocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Accept a local stream connection");
    }

    protected IoFuture<ConnectedStreamChannel> acceptTcpStream(InetSocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Accept a TCP connection");
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdpDatagram(Xnio.ANY_INET_ADDRESS, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalDatagram(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to datagram server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdpDatagram((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectLocalDatagram((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> connectUdpDatagram(InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to UDP server");
    }

    protected IoFuture<ConnectedMessageChannel> connectLocalDatagram(LocalSocketAddress bindAddress, LocalSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local datagram server");
    }

    public IoFuture<ConnectedMessageChannel> acceptDatagram(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalDatagram((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> acceptLocalDatagram(LocalSocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Accept a local message connection");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UDP Server");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, ChannelListeners.nullChannelListener(), optionMap);
    }

    @Deprecated
    public void createPipe(ChannelListener<? super StreamChannel> leftOpenListener, ChannelListener<? super StreamChannel> rightOpenListener, OptionMap optionMap) throws IOException {
        ChannelPipe<StreamChannel, StreamChannel> pipe = this.createFullDuplexPipe();
        boolean establishWriting = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
        StreamChannel left = pipe.getLeftSide();
        XnioExecutor leftExec = establishWriting ? left.getWriteThread() : left.getReadThread();
        StreamChannel right = pipe.getRightSide();
        XnioExecutor rightExec = establishWriting ? right.getWriteThread() : right.getReadThread();
        leftExec.execute(ChannelListeners.getChannelListenerTask(left, leftOpenListener));
        rightExec.execute(ChannelListeners.getChannelListenerTask(right, rightOpenListener));
    }

    @Deprecated
    public void createOneWayPipe(ChannelListener<? super StreamSourceChannel> sourceListener, ChannelListener<? super StreamSinkChannel> sinkListener, OptionMap optionMap) throws IOException {
        ChannelPipe<StreamSourceChannel, StreamSinkChannel> pipe = this.createHalfDuplexPipe();
        StreamSourceChannel left = pipe.getLeftSide();
        XnioExecutor leftExec = left.getReadThread();
        StreamSinkChannel right = pipe.getRightSide();
        XnioExecutor rightExec = right.getWriteThread();
        leftExec.execute(ChannelListeners.getChannelListenerTask(left, sourceListener));
        rightExec.execute(ChannelListeners.getChannelListenerTask(right, sinkListener));
    }

    public StreamSourceChannel getInflatingChannel(StreamSourceChannel delegate, OptionMap options) throws IOException {
        boolean nowrap;
        switch (options.get(Options.COMPRESSION_TYPE, CompressionType.DEFLATE)) {
            case DEFLATE: {
                nowrap = false;
                break;
            }
            case GZIP: {
                nowrap = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression format not supported");
            }
        }
        return this.getInflatingChannel(delegate, new Inflater(nowrap));
    }

    protected StreamSourceChannel getInflatingChannel(final StreamSourceChannel delegate, final Inflater inflater) throws IOException {
        ChannelPipe<StreamSourceChannel, StreamSinkChannel> pipe = this.createHalfDuplexPipe();
        StreamSourceChannel source = pipe.getLeftSide();
        final StreamSinkChannel sink = pipe.getRightSide();
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                InflaterInputStream inputStream = new InflaterInputStream(new ChannelInputStream(delegate), inflater);
                byte[] buf = new byte[16384];
                ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
                try {
                    while (true) {
                        int res;
                        if ((res = inputStream.read(buf)) == -1) {
                            sink.shutdownWrites();
                            Channels.flushBlocking(sink);
                            return;
                        }
                        byteBuffer.limit(res);
                        Channels.writeBlocking(sink, byteBuffer);
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    return;
                }
                finally {
                    IoUtils.safeClose((Closeable)inputStream);
                    IoUtils.safeClose((Closeable)sink);
                }
            }
        });
        return source;
    }

    public StreamSinkChannel getDeflatingChannel(StreamSinkChannel delegate, OptionMap options) throws IOException {
        boolean nowrap;
        int level = options.get(Options.COMPRESSION_LEVEL, -1);
        switch (options.get(Options.COMPRESSION_TYPE, CompressionType.DEFLATE)) {
            case DEFLATE: {
                nowrap = false;
                break;
            }
            case GZIP: {
                nowrap = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression format not supported");
            }
        }
        return this.getDeflatingChannel(delegate, new Deflater(level, nowrap));
    }

    protected StreamSinkChannel getDeflatingChannel(final StreamSinkChannel delegate, final Deflater deflater) throws IOException {
        ChannelPipe<StreamSourceChannel, StreamSinkChannel> pipe = this.createHalfDuplexPipe();
        final StreamSourceChannel source = pipe.getLeftSide();
        StreamSinkChannel sink = pipe.getRightSide();
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                DeflaterOutputStream outputStream = new DeflaterOutputStream((OutputStream)new ChannelOutputStream(delegate), deflater);
                byte[] buf = new byte[16384];
                ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
                try {
                    while (true) {
                        if (Channels.readBlocking(source, byteBuffer) == -1) {
                            outputStream.close();
                            return;
                        }
                        outputStream.write(buf, 0, byteBuffer.position());
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    return;
                }
                finally {
                    IoUtils.safeClose((Closeable)outputStream);
                    IoUtils.safeClose((Closeable)source);
                }
            }
        });
        return sink;
    }

    public ChannelPipe<StreamChannel, StreamChannel> createFullDuplexPipe() throws IOException {
        throw new UnsupportedOperationException("Create a full-duplex pipe");
    }

    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe() throws IOException {
        throw new UnsupportedOperationException("Create a half-duplex pipe");
    }

    @Override
    public abstract void shutdown();

    @Override
    public abstract List<Runnable> shutdownNow();

    @Override
    public abstract boolean isShutdown();

    @Override
    public abstract boolean isTerminated();

    @Override
    public abstract boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public abstract void awaitTermination() throws InterruptedException;

    protected Runnable getTerminationTask() {
        return this.terminationTask;
    }

    protected void taskPoolTerminated() {
    }

    protected void shutDownTaskPool() {
        this.taskPool.shutdown();
    }

    protected List<Runnable> shutDownTaskPoolNow() {
        return this.taskPool.shutdownNow();
    }

    @Override
    public void execute(Runnable command) {
        this.taskPool.execute(command);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option.equals(Options.WORKER_TASK_CORE_THREADS)) {
            return option.cast(this.taskPool.getCorePoolSize());
        }
        if (option.equals(Options.WORKER_TASK_MAX_THREADS)) {
            return option.cast(this.taskPool.getMaximumPoolSize());
        }
        if (option.equals(Options.WORKER_TASK_KEEPALIVE)) {
            return option.cast((int)Math.min(Integer.MAX_VALUE, this.taskPool.getKeepAliveTime(TimeUnit.MILLISECONDS)));
        }
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option.equals(Options.WORKER_TASK_CORE_THREADS)) {
            int old = this.taskPool.getCorePoolSize();
            this.taskPool.setCorePoolSize(Options.WORKER_TASK_CORE_THREADS.cast(value));
            return option.cast(old);
        }
        if (option.equals(Options.WORKER_TASK_MAX_THREADS)) {
            int old = this.taskPool.getMaximumPoolSize();
            this.taskPool.setMaximumPoolSize(Options.WORKER_TASK_CORE_THREADS.cast(value));
            return option.cast(old);
        }
        if (option.equals(Options.WORKER_TASK_KEEPALIVE)) {
            long old = this.taskPool.getKeepAliveTime(TimeUnit.MILLISECONDS);
            this.taskPool.setKeepAliveTime(Options.WORKER_TASK_KEEPALIVE.cast(value).intValue(), TimeUnit.MILLISECONDS);
            return option.cast((int)Math.min(Integer.MAX_VALUE, old));
        }
        return null;
    }

    public void migrate(CloseableChannel channel) throws IOException, IllegalArgumentException {
        if (channel.getWorker().getXnio() != this.xnio) {
            throw new IllegalArgumentException("Cannot migrate channel (XNIO providers do not match)");
        }
        this.doMigration(channel);
    }

    protected abstract void doMigration(CloseableChannel var1) throws IOException;

    public Xnio getXnio() {
        return this.xnio;
    }

    public String getName() {
        return this.name;
    }

    final class TaskPool
    extends ThreadPoolExecutor {
        TaskPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        protected void terminated() {
            XnioWorker.this.taskPoolTerminated();
        }
    }
}

