/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.Buffers;
import org.xnio.conduits.MessageSinkConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class Conduits {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(StreamSourceConduit source, long count, ByteBuffer throughBuffer, WritableByteChannel sink) throws IOException {
        long total;
        long res;
        throughBuffer.limit(0);
        for (total = 0L; total < count; total += res) {
            throughBuffer.compact();
            try {
                if (count - total < (long)throughBuffer.remaining()) {
                    throughBuffer.limit((int)(count - total));
                }
                if ((res = (long)source.read(throughBuffer)) <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res != 0L) continue;
            return total;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source, long count, ByteBuffer throughBuffer, StreamSinkConduit sink) throws IOException {
        long total;
        long res;
        throughBuffer.limit(0);
        for (total = 0L; total < count; total += res) {
            throughBuffer.compact();
            try {
                if (count - total < (long)throughBuffer.remaining()) {
                    throughBuffer.limit((int)(count - total));
                }
                if ((res = (long)source.read(throughBuffer)) <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res != 0L) continue;
            return total;
        }
        return total;
    }

    public static int writeFinalBasic(StreamSinkConduit conduit, ByteBuffer src) throws IOException {
        int res = conduit.write(src);
        if (!src.hasRemaining()) {
            conduit.terminateWrites();
        }
        return res;
    }

    public static long writeFinalBasic(StreamSinkConduit conduit, ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res = conduit.write(srcs, offset, length);
        if (!Buffers.hasRemaining(srcs, offset, length)) {
            conduit.terminateWrites();
        }
        return res;
    }

    public static boolean sendFinalBasic(MessageSinkConduit conduit, ByteBuffer src) throws IOException {
        if (conduit.send(src)) {
            conduit.terminateWrites();
            return true;
        }
        return false;
    }

    public static boolean sendFinalBasic(MessageSinkConduit conduit, ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (conduit.send(srcs, offset, length)) {
            conduit.terminateWrites();
            return true;
        }
        return false;
    }
}

