/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ConnectionChannelThread;
import org.xnio.FailedIoFuture;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Version;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.nio.AbstractNioChannelThread;
import org.xnio.nio.BioMulticastUdpChannel;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioReadChannelThread;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioWriteChannelThread;

final class NioXnio
extends Xnio {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio");
    private final SelectorCreator selectorCreator;
    static final boolean NIO2;
    private final ThreadLocal<Selector> selectorThreadLocal = new ThreadLocal<Selector>(){

        @Override
        public void remove() {
            IoUtils.safeClose((Selector)((Selector)this.get()));
            super.remove();
        }
    };

    NioXnio() {
        super("nio");
        String providerClassName = SelectorProvider.provider().getClass().getCanonicalName();
        if ("sun.nio.ch.PollSelectorProvider".equals(providerClassName)) {
            log.warnf("The currently defined selector provider class (%s) is not supported for use with XNIO", (Object)providerClassName);
        }
        log.tracef("Starting up with selector provider %s", (Object)providerClassName);
        this.selectorCreator = AccessController.doPrivileged(new PrivilegedAction<SelectorCreator>(){

            @Override
            public SelectorCreator run() {
                try {
                    Class<Selector> selectorImplClass = Class.forName("sun.nio.ch.PollSelectorImpl").asSubclass(Selector.class);
                    final Constructor<Selector> constructor = selectorImplClass.getDeclaredConstructor(SelectorProvider.class);
                    constructor.setAccessible(true);
                    log.trace((Object)"Using polling selector type for temporary selectors.");
                    return new SelectorCreator(){

                        @Override
                        public Selector open() throws IOException {
                            try {
                                return (Selector)constructor.newInstance(SelectorProvider.provider());
                            }
                            catch (InstantiationException e) {
                                return Selector.open();
                            }
                            catch (IllegalAccessException e) {
                                return Selector.open();
                            }
                            catch (InvocationTargetException e) {
                                try {
                                    throw e.getTargetException();
                                }
                                catch (IOException e2) {
                                    throw e2;
                                }
                                catch (RuntimeException e2) {
                                    throw e2;
                                }
                                catch (Error e2) {
                                    throw e2;
                                }
                                catch (Throwable t) {
                                    throw new IllegalStateException("Unexpected invocation exception", t);
                                }
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    log.trace((Object)"Using default selector type for temporary selectors.");
                    return new SelectorCreator(){

                        @Override
                        public Selector open() throws IOException {
                            return Selector.open();
                        }
                    };
                }
            }
        });
    }

    public ReadChannelThread createReadChannelThread(ThreadGroup threadGroup, OptionMap optionMap) throws IOException {
        NioReadChannelThread thread = new NioReadChannelThread(threadGroup, optionMap);
        thread.start();
        return thread;
    }

    public WriteChannelThread createWriteChannelThread(ThreadGroup threadGroup, OptionMap optionMap) throws IOException {
        NioWriteChannelThread thread = new NioWriteChannelThread(threadGroup, optionMap);
        thread.start();
        return thread;
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(bindAddress);
        NioTcpServer server = new NioTcpServer(this, channel);
        server.getAcceptSetter().set(acceptListener);
        server.setAcceptThread(thread);
        return server;
    }

    protected IoFuture<ConnectedStreamChannel> connectStreamTcp(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            final NioTcpChannel tcpChannel = new NioTcpChannel(this, channel);
            ChannelListeners.invokeChannelListener((Channel)tcpChannel.getBoundChannel(), bindListener);
            if (channel.connect(destinationAddress)) {
                tcpChannel.setReadThread(readThread);
                tcpChannel.setWriteThread(writeThread);
                ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), openListener);
                return new FinishedIoFuture((Object)tcpChannel);
            }
            NioSetter<SocketChannel> setter = new NioSetter<SocketChannel>();
            final FutureResult futureResult = new FutureResult();
            final NioHandle<SocketChannel> handle = ((AbstractNioChannelThread)thread).addChannel(channel, channel, 0, setter);
            setter.set(new ChannelListener<SocketChannel>(){

                public void handleEvent(SocketChannel channel2) {
                    try {
                        if (channel2.finishConnect()) {
                            handle.cancelKey();
                            tcpChannel.setReadThread(readThread);
                            tcpChannel.setWriteThread(writeThread);
                            futureResult.setResult((Object)tcpChannel);
                            ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel2);
                        handle.cancelKey();
                        futureResult.setException(e);
                    }
                }

                public String toString() {
                    return "Connection finisher for " + channel;
                }
            });
            futureResult.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    if (futureResult.setCancelled()) {
                        handle.cancelKey();
                        IoUtils.safeClose((Closeable)channel);
                    }
                    return this;
                }

                public String toString() {
                    return "Cancel handler for " + channel;
                }
            });
            handle.resume(8);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    protected IoFuture<ConnectedStreamChannel> acceptStreamTcp(InetSocketAddress destination, ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        try {
            final ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(destination);
            final NioSetter closeSetter = new NioSetter();
            ChannelListeners.invokeChannelListener((Channel)new BoundChannel(){

                public SocketAddress getLocalAddress() {
                    return channel.socket().getLocalSocketAddress();
                }

                public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                    SocketAddress address = this.getLocalAddress();
                    return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
                }

                public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                    return closeSetter;
                }

                public boolean isOpen() {
                    return channel.isOpen();
                }

                public boolean supportsOption(Option<?> option) {
                    return false;
                }

                public <T> T getOption(Option<T> option) throws IOException {
                    return null;
                }

                public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                    return null;
                }

                public void close() throws IOException {
                    channel.close();
                }

                public String toString() {
                    return String.format("TCP acceptor bound channel (NIO) <%h>", this);
                }
            }, bindListener);
            SocketChannel accepted = channel.accept();
            if (accepted != null) {
                IoUtils.safeClose((Closeable)channel);
                NioTcpChannel tcpChannel = new NioTcpChannel(this, accepted);
                tcpChannel.setReadThread(readThread);
                tcpChannel.setWriteThread(writeThread);
                ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), openListener);
                return new FinishedIoFuture((Object)tcpChannel);
            }
            NioSetter<ServerSocketChannel> setter = new NioSetter<ServerSocketChannel>();
            final FutureResult futureResult = new FutureResult();
            final NioHandle<ServerSocketChannel> handle = ((AbstractNioChannelThread)thread).addChannel(channel, channel, 0, setter);
            setter.set(new ChannelListener<ServerSocketChannel>(){

                public void handleEvent(ServerSocketChannel channel2) {
                    SocketChannel accepted;
                    try {
                        accepted = channel2.accept();
                        if (accepted == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel2);
                        handle.cancelKey();
                        futureResult.setException(e);
                        return;
                    }
                    handle.cancelKey();
                    IoUtils.safeClose((Closeable)channel2);
                    try {
                        accepted.configureBlocking(false);
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)accepted);
                        futureResult.setException(e);
                        return;
                    }
                    NioTcpChannel tcpChannel = new NioTcpChannel(NioXnio.this, accepted);
                    tcpChannel.setReadThread(readThread);
                    tcpChannel.setWriteThread(writeThread);
                    futureResult.setResult((Object)tcpChannel);
                    ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                }

                public String toString() {
                    return "Accepting finisher for " + channel;
                }
            });
            handle.resume(16);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        if (!NIO2 && optionMap.get(Options.MULTICAST, false)) {
            MulticastSocket socket = new MulticastSocket(bindAddress);
            BioMulticastUdpChannel channel = new BioMulticastUdpChannel(optionMap.get(Options.SEND_BUFFER, 8192), optionMap.get(Options.RECEIVE_BUFFER, 8192), socket);
            channel.setReadThread(readThread);
            channel.setWriteThread(writeThread);
            channel.open();
            ChannelListeners.invokeChannelListener((Channel)((Object)channel), bindListener);
            return channel;
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        udpChannel.setReadThread(readThread);
        udpChannel.setWriteThread(writeThread);
        ChannelListeners.invokeChannelListener((Channel)((Object)udpChannel), bindListener);
        return udpChannel;
    }

    Selector getSelector() throws IOException {
        ThreadLocal<Selector> threadLocal = this.selectorThreadLocal;
        Selector selector = threadLocal.get();
        if (selector == null) {
            selector = this.selectorCreator.open();
            threadLocal.set(selector);
        }
        return selector;
    }

    static {
        log.info((Object)("XNIO NIO Implementation Version " + Version.VERSION));
        boolean nio2 = false;
        try {
            Class.forName("java.nio.channels.MulticastChannel", false, null);
            nio2 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NIO2 = nio2;
    }

    private static interface SelectorCreator {
        public Selector open() throws IOException;
    }
}

