/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Bits;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelPipe;
import org.xnio.ClosedWorkerException;
import org.xnio.FailedIoFuture;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeChannel;
import org.xnio.nio.NioPipeSinkChannel;
import org.xnio.nio.NioPipeSourceChannel;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private volatile int state = 1;
    private final WorkerThread[] readWorkers;
    private final WorkerThread[] writeWorkers;
    private volatile Thread shutdownWaiter;
    private static final AtomicReferenceFieldUpdater<NioXnioWorker, Thread> shutdownWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(NioXnioWorker.class, Thread.class, "shutdownWaiter");
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");
    private static final WorkerThread[] NO_WORKERS = new WorkerThread[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(NioXnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException {
        super((Xnio)xnio, threadGroup, optionMap, terminationTask);
        int readCount = optionMap.get(Options.WORKER_READ_THREADS, 1);
        if (readCount < 0) {
            throw new IllegalArgumentException("Worker read thread count must be >= 0");
        }
        int writeCount = optionMap.get(Options.WORKER_WRITE_THREADS, 1);
        if (writeCount < 0) {
            throw new IllegalArgumentException("Worker write thread count must be >= 0");
        }
        long workerStackSize = optionMap.get(Options.STACK_SIZE, 0L);
        if (workerStackSize < 0L) {
            throw new IllegalArgumentException("Worker stack size must be >= 0");
        }
        String workerName = this.getName();
        WorkerThread[] readWorkers = new WorkerThread[readCount];
        WorkerThread[] writeWorkers = new WorkerThread[writeCount];
        boolean markWorkerThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        boolean ok = false;
        try {
            int i;
            for (i = 0; i < readCount; ++i) {
                WorkerThread readWorker = new WorkerThread(this, xnio.mainSelectorCreator.open(), String.format("%s read-%d", workerName, i + 1), threadGroup, workerStackSize, false);
                if (markWorkerThreadAsDaemon) {
                    readWorker.setDaemon(true);
                }
                readWorkers[i] = readWorker;
            }
            for (i = 0; i < writeCount; ++i) {
                WorkerThread writeWorker = new WorkerThread(this, xnio.mainSelectorCreator.open(), String.format("%s write-%d", workerName, i + 1), threadGroup, workerStackSize, true);
                if (markWorkerThreadAsDaemon) {
                    writeWorker.setDaemon(true);
                }
                writeWorkers[i] = writeWorker;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : readWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose((Selector)worker.getSelector());
                }
                for (WorkerThread worker : writeWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose((Selector)worker.getSelector());
                }
            }
        }
        this.readWorkers = readWorkers;
        this.writeWorkers = writeWorkers;
    }

    void start() {
        for (WorkerThread worker : this.readWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
        for (WorkerThread worker : this.writeWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
    }

    WorkerThread chooseOptional(boolean write) {
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return orig[0];
        }
        Random random = IoUtils.getThreadLocalRandom();
        return orig[random.nextInt(length)];
    }

    WorkerThread choose(boolean write) {
        WorkerThread result = this.chooseOptional(write);
        if (result == null) {
            throw new IllegalArgumentException("No threads configured");
        }
        return result;
    }

    WorkerThread[] choose(int count, boolean write) {
        HashSet<Object> set;
        if (count == 0) {
            return NO_WORKERS;
        }
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        int halfLength = length >> 1;
        if (length == 0) {
            throw new IllegalArgumentException("No threads configured");
        }
        if (count == length) {
            return orig;
        }
        if (count > length) {
            throw new IllegalArgumentException("Not enough " + (write ? "write" : "read") + " threads configured");
        }
        WorkerThread[] result = new WorkerThread[count];
        Random random = IoUtils.getThreadLocalRandom();
        if (count == 1) {
            result[0] = orig[random.nextInt(length)];
            return result;
        }
        if (length < 32) {
            if (count >= halfLength) {
                int bits = (1 << length) - 1;
                while (Integer.bitCount(bits &= ~(1 << random.nextInt(length))) > count) {
                }
                for (int i = 0; i < count; ++i) {
                    int bit = Integer.numberOfTrailingZeros(bits);
                    result[i] = orig[bit];
                    bits ^= Integer.lowestOneBit(bits);
                }
                return result;
            }
            int bits = 0;
            while (Integer.bitCount(bits |= 1 << random.nextInt(length)) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Integer.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Integer.lowestOneBit(bits);
            }
            return result;
        }
        if (length < 64) {
            if (count >= halfLength) {
                long bits = (1L << (int)((long)length)) - 1L;
                while (Long.bitCount(bits &= 1L << (int)((long)random.nextInt(length)) ^ 0xFFFFFFFFFFFFFFFFL) > count) {
                }
                for (int i = 0; i < count; ++i) {
                    int bit = Long.numberOfTrailingZeros(bits);
                    result[i] = orig[bit];
                    bits ^= Long.lowestOneBit(bits);
                }
                return result;
            }
            long bits = 0L;
            while (Long.bitCount(bits |= 1L << (int)((long)random.nextInt(length))) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Long.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Long.lowestOneBit(bits);
            }
            return result;
        }
        if (count >= halfLength) {
            set = new HashSet<WorkerThread>(Arrays.asList(orig));
            while (set.size() > count) {
                set.remove(orig[random.nextInt(length)]);
            }
        } else {
            set = new HashSet(length);
            while (set.size() < count) {
                set.add(orig[random.nextInt(length)]);
            }
        }
        return set.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            channel.configureBlocking(false);
            if (optionMap.contains(Options.BACKLOG)) {
                channel.socket().bind(bindAddress, optionMap.get(Options.BACKLOG, 128));
            } else {
                channel.socket().bind(bindAddress);
            }
            NioTcpServer server = new NioTcpServer(this, channel, optionMap);
            ChannelListener.SimpleSetter<NioTcpServer> setter = server.getAcceptSetter();
            setter.set(acceptListener);
            ok = true;
            NioTcpServer nioTcpServer = server;
            return nioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    protected IoFuture<ConnectedStreamChannel> connectTcpStream(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        try {
            this.checkShutdown();
        }
        catch (ClosedWorkerException e) {
            return new FailedIoFuture((IOException)((Object)e));
        }
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            final NioTcpChannel tcpChannel = new NioTcpChannel(this, null, channel);
            tcpChannel.start();
            final NioHandle connectHandle = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false) ? tcpChannel.getWriteHandle() : tcpChannel.getReadHandle();
            final int oldOps = connectHandle.setOps(8);
            if (connectHandle == null) {
                throw new IllegalArgumentException("Wrong value for option " + Options.WORKER_ESTABLISH_WRITING + ". This NioWorker has no " + (optionMap.get(Options.WORKER_ESTABLISH_WRITING, false) ? "write" : "read") + " thread.");
            }
            ChannelListeners.invokeChannelListener((Channel)tcpChannel.getBoundChannel(), bindListener);
            if (channel.connect(destinationAddress)) {
                connectHandle.getWorkerThread().execute(ChannelListeners.getChannelListenerTask((Channel)((Object)tcpChannel), openListener));
                return new FinishedIoFuture((Object)tcpChannel);
            }
            ChannelListener.SimpleSetter setter = connectHandle.getHandlerSetter();
            final FutureResult futureResult = new FutureResult();
            setter.set((ChannelListener)new ChannelListener<NioTcpChannel>(){

                public void handleEvent(NioTcpChannel channel2) {
                    SocketChannel socketChannel = channel2.getReadChannel();
                    try {
                        if (socketChannel.finishConnect()) {
                            connectHandle.suspend();
                            connectHandle.getHandlerSetter().set(null);
                            connectHandle.setOps(oldOps);
                            if (!futureResult.setResult((Object)tcpChannel)) {
                                IoUtils.safeClose((Closeable)((Object)channel2));
                            } else {
                                channel2.configureFrom(optionMap);
                                ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                            }
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)((Object)channel2));
                        futureResult.setException(e);
                    }
                }

                public String toString() {
                    return "Connection finisher for " + channel;
                }
            });
            futureResult.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    if (futureResult.setCancelled()) {
                        IoUtils.safeClose((Closeable)((Object)tcpChannel));
                    }
                    return this;
                }

                public String toString() {
                    return "Cancel handler for " + channel;
                }
            });
            connectHandle.resume();
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    protected IoFuture<ConnectedStreamChannel> acceptTcpStream(InetSocketAddress destination, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        try {
            this.checkShutdown();
        }
        catch (ClosedWorkerException e) {
            return new FailedIoFuture((IOException)((Object)e));
        }
        WorkerThread connectThread = this.choose(optionMap.get(Options.WORKER_ESTABLISH_WRITING, false));
        try {
            final ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(destination);
            final ChannelListener.SimpleSetter closeSetter = new ChannelListener.SimpleSetter();
            ChannelListeners.invokeChannelListener((Channel)new BoundChannel(){

                public XnioWorker getWorker() {
                    return NioXnioWorker.this;
                }

                public SocketAddress getLocalAddress() {
                    return channel.socket().getLocalSocketAddress();
                }

                public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                    SocketAddress address = this.getLocalAddress();
                    return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
                }

                public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                    return closeSetter;
                }

                public boolean isOpen() {
                    return channel.isOpen();
                }

                public boolean supportsOption(Option<?> option) {
                    return false;
                }

                public <T> T getOption(Option<T> option) throws IOException {
                    return null;
                }

                public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                    return null;
                }

                public void close() throws IOException {
                    channel.close();
                }

                public String toString() {
                    return String.format("TCP acceptor bound channel (NIO) <%h>", this);
                }
            }, bindListener);
            SocketChannel accepted = channel.accept();
            if (accepted != null) {
                IoUtils.safeClose((Closeable)channel);
                NioTcpChannel tcpChannel = new NioTcpChannel(this, null, accepted);
                tcpChannel.start();
                tcpChannel.configureFrom(optionMap);
                ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), openListener);
                return new FinishedIoFuture((Object)tcpChannel);
            }
            ChannelListener.SimpleSetter setter = new ChannelListener.SimpleSetter();
            final FutureResult futureResult = new FutureResult();
            final NioHandle<ServerSocketChannel> handle = connectThread.addChannel(channel, channel, 16, setter);
            setter.set((ChannelListener)new ChannelListener<ServerSocketChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleEvent(ServerSocketChannel channel2) {
                    SocketChannel accepted;
                    try {
                        accepted = channel2.accept();
                        if (accepted == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel2);
                        handle.cancelKey();
                        futureResult.setException(e);
                        return;
                    }
                    boolean ok = false;
                    try {
                        handle.cancelKey();
                        IoUtils.safeClose((Closeable)channel2);
                        try {
                            accepted.configureBlocking(false);
                            NioTcpChannel tcpChannel = new NioTcpChannel(NioXnioWorker.this, null, accepted);
                            tcpChannel.start();
                            tcpChannel.configureFrom(optionMap);
                            futureResult.setResult((Object)tcpChannel);
                            ok = true;
                            ChannelListeners.invokeChannelListener((Channel)((Object)tcpChannel), (ChannelListener)openListener);
                        }
                        catch (IOException e) {
                            futureResult.setException(e);
                            if (!ok) {
                                IoUtils.safeClose((Closeable)accepted);
                            }
                            return;
                        }
                    }
                    finally {
                        if (!ok) {
                            IoUtils.safeClose((Closeable)accepted);
                        }
                    }
                }

                public String toString() {
                    return "Accepting finisher for " + channel;
                }
            });
            handle.resume();
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        udpChannel.start();
        ChannelListeners.invokeChannelListener((Channel)((Object)udpChannel), bindListener);
        return udpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPipe<StreamChannel, StreamChannel> createFullDuplexPipe() throws IOException {
        this.checkShutdown();
        boolean ok = false;
        Pipe in = Pipe.open();
        try {
            ChannelPipe channelPipe;
            block8: {
                in.source().configureBlocking(false);
                in.sink().configureBlocking(false);
                Pipe out = Pipe.open();
                try {
                    out.source().configureBlocking(false);
                    out.sink().configureBlocking(false);
                    NioPipeChannel left = new NioPipeChannel(this, in.sink(), out.source());
                    left.start();
                    NioPipeChannel right = new NioPipeChannel(this, out.sink(), in.source());
                    right.start();
                    ChannelPipe result = new ChannelPipe((CloseableChannel)left, (CloseableChannel)right);
                    ok = true;
                    channelPipe = result;
                    if (ok) break block8;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        IoUtils.safeClose((Closeable)out.sink());
                        IoUtils.safeClose((Closeable)out.source());
                    }
                    throw throwable;
                }
                IoUtils.safeClose((Closeable)out.sink());
                IoUtils.safeClose((Closeable)out.source());
            }
            return channelPipe;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)in.sink());
                IoUtils.safeClose((Closeable)in.source());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe() throws IOException {
        this.checkShutdown();
        Pipe pipe = Pipe.open();
        boolean ok = false;
        try {
            pipe.source().configureBlocking(false);
            pipe.sink().configureBlocking(false);
            NioPipeSourceChannel sourceChannel = new NioPipeSourceChannel(this, pipe.source());
            sourceChannel.start();
            NioPipeSinkChannel sinkChannel = new NioPipeSinkChannel(this, pipe.sink());
            sinkChannel.start();
            ChannelPipe result = new ChannelPipe((CloseableChannel)sourceChannel, (CloseableChannel)sinkChannel);
            ok = true;
            ChannelPipe channelPipe = result;
            return channelPipe;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)pipe.sink());
                IoUtils.safeClose((Closeable)pipe.source());
            }
        }
    }

    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void checkShutdown() throws ClosedWorkerException {
        if (this.isShutdown()) {
            throw new ClosedWorkerException("Worker is shut down");
        }
    }

    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)(oldState + 1), (Object)oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, (Object)Integer.MIN_VALUE, (Object)-1073741824);
                NioXnioWorker.safeUnpark(shutdownWaiterUpdater.getAndSet(this, null));
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.readWorkers) {
                worker.shutdown();
            }
            for (WorkerThread worker : this.writeWorkers) {
                worker.shutdown();
            }
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet((int)oldState, (int)0x40000000)) {
            return true;
        }
        long then = System.nanoTime();
        long duration = unit.toNanos(timeout);
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear((int)(oldState = this.state), (int)0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                oldState = this.state;
                if (Bits.allAreSet((int)oldState, (int)0x40000000)) break;
                LockSupport.parkNanos((Object)this, duration);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long now = System.nanoTime();
                if ((duration -= now - then) >= 0L) continue;
                oldState = this.state;
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
        return Bits.allAreSet((int)oldState, (int)0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination() throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet((int)oldState, (int)0x40000000)) {
            return;
        }
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear((int)this.state, (int)0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                if (!Bits.allAreSet((int)this.state, (int)0x40000000)) {
                    LockSupport.park((Object)this);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    protected void doMigration(CloseableChannel channel) throws ClosedChannelException {
        if (channel.getWorker() == this) {
            return;
        }
        ((AbstractNioChannel)channel).migrateTo(this);
    }

    protected void taskPoolTerminated() {
        this.closeResource();
    }

    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }
}

