/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.test.Asserter;
import kotlin.test.AsserterContributor;
import kotlin.test.DefaultAsserter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\t\u001a\u00020\nH\u0002\u001a\b\u0010\u000b\u001a\u00020\nH\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\b\u0010\u000e\u001a\u00020\rH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"contributors", "Ljava/util/ArrayList;", "Lkotlin/test/AsserterContributor;", "defaultAsserter", "Lkotlin/test/DefaultAsserter;", "inited", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "initContributors", "", "initContributorsIfNeeded", "lookup", "Lkotlin/test/Asserter;", "lookupAsserter", "kotlin-test"})
public final class AsserterLookupKt {
    private static final AtomicBoolean inited = new AtomicBoolean();
    private static final ReentrantLock lock = new ReentrantLock();
    private static final ArrayList<AsserterContributor> contributors = new ArrayList();
    private static final DefaultAsserter defaultAsserter = new DefaultAsserter();

    @NotNull
    public static final Asserter lookupAsserter() {
        return AsserterLookupKt.lookup();
    }

    @NotNull
    public static final Asserter lookup() {
        AsserterLookupKt.initContributorsIfNeeded();
        for (AsserterContributor contributor : contributors) {
            Asserter asserter = contributor.contribute();
            if (asserter == null) continue;
            return asserter;
        }
        return defaultAsserter;
    }

    private static final void initContributors() {
        contributors.clear();
        ServiceLoader<AsserterContributor> loader = ServiceLoader.load(AsserterContributor.class);
        for (AsserterContributor contributor : loader) {
            if (contributor == null) continue;
            contributors.add(contributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initContributorsIfNeeded() {
        if (!inited.get()) {
            Lock lock = AsserterLookupKt.lock;
            lock.lock();
            try {
                if (inited.compareAndSet(false, true)) {
                    AsserterLookupKt.initContributors();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

