/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi;

import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.osgi.OsgiAgentServlet;
import org.jolokia.server.core.osgi.security.Authenticator;
import org.jolokia.server.core.osgi.security.BasicAuthenticationHttpContext;
import org.jolokia.server.core.osgi.security.BasicAuthenticator;
import org.jolokia.server.core.osgi.security.DefaultServletContextHelper;
import org.jolokia.server.core.osgi.security.DelegatingRestrictor;
import org.jolokia.server.core.osgi.security.JaasAuthenticator;
import org.jolokia.server.core.osgi.security.ServiceAuthenticationServletContextHelper;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.util.NetworkUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.servlet.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiAgentActivator
implements BundleActivator {
    private BundleContext bundleContext;
    private ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configAdminTracker;
    private static final String CONFIG_PREFIX = "org.jolokia";
    private static final String CONFIG_ADMIN_PID = "org.jolokia.osgi";
    private ServletContextHelper jolokiaContextHelper;
    private Restrictor restrictor = null;
    private ServiceRegistration<ServletContextHelper> contextRegistration = null;
    private ServiceRegistration<HttpServlet> servletRegistration = null;

    public void start(BundleContext pBundleContext) {
        this.bundleContext = pBundleContext;
        this.configAdminTracker = new ServiceTracker(pBundleContext, "org.osgi.service.cm.ConfigurationAdmin", null);
        this.configAdminTracker.open();
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.USE_RESTRICTOR_SERVICE))) {
            this.restrictor = new DelegatingRestrictor(this.bundleContext);
        }
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.REGISTER_WHITEBOARD_SERVLET, ConfigKey.LISTEN_FOR_HTTP_SERVICE))) {
            this.registerWhiteboardServlet(pBundleContext);
        }
    }

    public void stop(BundleContext pBundleContext) {
        assert (pBundleContext.equals((Object)this.bundleContext));
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
            this.contextRegistration.unregister();
        }
        if (this.configAdminTracker != null) {
            this.configAdminTracker.close();
            this.configAdminTracker = null;
        }
        if (this.jolokiaContextHelper instanceof ServiceAuthenticationServletContextHelper) {
            ServiceAuthenticationServletContextHelper context = (ServiceAuthenticationServletContextHelper)this.jolokiaContextHelper;
            context.close();
        }
        this.restrictor = null;
        this.bundleContext = null;
    }

    public synchronized ServletContextHelper getServletContextHelper() {
        if (this.jolokiaContextHelper == null) {
            String user = this.getConfiguration(ConfigKey.USER);
            String authMode = this.getConfiguration(ConfigKey.AUTH_MODE);
            this.jolokiaContextHelper = user != null || "jaas".equalsIgnoreCase(authMode) ? new BasicAuthenticationHttpContext(this.getConfiguration(ConfigKey.REALM), this.createAuthenticator(authMode)) : (ServiceAuthenticationServletContextHelper.shouldBeUsed(authMode) ? new ServiceAuthenticationServletContextHelper(this.bundleContext, authMode) : new DefaultServletContextHelper());
        }
        return this.jolokiaContextHelper;
    }

    public String getServletContextPath() {
        return this.getConfiguration(ConfigKey.AGENT_CONTEXT);
    }

    private Dictionary<String, String> getConfiguration() {
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (ConfigKey key : ConfigKey.values()) {
            String value = this.getConfiguration(key);
            if (value == null) continue;
            ((Dictionary)config).put(key.getKeyValue(), value);
        }
        String jolokiaId = (String)((Dictionary)config).get(ConfigKey.AGENT_ID.getKeyValue());
        if (jolokiaId == null) {
            ((Dictionary)config).put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId(this.hashCode(), "osgi"));
        }
        ((Dictionary)config).put(ConfigKey.AGENT_TYPE.getKeyValue(), "osgi");
        return config;
    }

    private String getConfiguration(ConfigKey pKey) {
        String value = this.getConfigurationFromConfigAdmin(pKey);
        if (value == null) {
            value = this.bundleContext.getProperty("org.jolokia." + pKey.getKeyValue());
        }
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    private String getConfiguration(ConfigKey pKey, ConfigKey fallbackKey) {
        String value = this.getConfigurationFromConfigAdmin(pKey);
        if (value == null) {
            value = this.bundleContext.getProperty("org.jolokia." + pKey.getKeyValue());
        }
        if (value == null) {
            value = this.getConfiguration(fallbackKey);
        }
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    private String getConfigurationFromConfigAdmin(ConfigKey pkey) {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminTracker.getService();
        if (configAdmin == null) {
            return null;
        }
        try {
            Configuration config = configAdmin.getConfiguration(CONFIG_ADMIN_PID);
            if (config == null) {
                return null;
            }
            Dictionary props = config.getProperties();
            if (props == null) {
                return null;
            }
            return (String)props.get("org.jolokia." + pkey.getKeyValue());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Authenticator createAuthenticator(String authMode) {
        Authenticator authenticator = this.createCustomAuthenticator();
        if (authenticator != null) {
            return authenticator;
        }
        return this.createAuthenticatorFromAuthMode(authMode);
    }

    private Authenticator createCustomAuthenticator() {
        String authenticatorClass = this.getConfiguration(ConfigKey.AUTH_CLASS);
        if (authenticatorClass != null) {
            try {
                Class<?> authClass = Class.forName(authenticatorClass);
                if (!Authenticator.class.isAssignableFrom(authClass)) {
                    throw new IllegalArgumentException("Provided authenticator class [" + authenticatorClass + "] is not a subclass of Authenticator");
                }
                return this.lookupAuthenticator(authClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find authenticator class", e);
            }
        }
        return null;
    }

    private Authenticator lookupAuthenticator(Class<?> pAuthClass) {
        Authenticator authenticator;
        try {
            try {
                Constructor<?> constructorThatTakesConfiguration = pAuthClass.getConstructor(Dictionary.class);
                authenticator = (Authenticator)constructorThatTakesConfiguration.newInstance(this.getConfiguration());
            }
            catch (NoSuchMethodException e) {
                authenticator = this.lookupAuthenticatorWithDefaultConstructor(pAuthClass, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create an instance of custom authenticator class with configuration", e);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        return authenticator;
    }

    private Authenticator lookupAuthenticatorWithDefaultConstructor(Class<?> pAuthClass, NoSuchMethodException ignore) throws InstantiationException, IllegalAccessException {
        try {
            Constructor<?> defaultConstructor = pAuthClass.getConstructor(new Class[0]);
            return (Authenticator)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class, no default constructor to use", e);
        }
        catch (InvocationTargetException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator using default constructor", e);
        }
    }

    private Authenticator createAuthenticatorFromAuthMode(String pAuthMode) {
        if ("basic".equalsIgnoreCase(pAuthMode)) {
            return new BasicAuthenticator(this.getConfiguration(ConfigKey.USER), this.getConfiguration(ConfigKey.PASSWORD));
        }
        if ("jaas".equalsIgnoreCase(pAuthMode)) {
            return new JaasAuthenticator(this.getConfiguration(ConfigKey.REALM));
        }
        throw new IllegalArgumentException("Unknown authentication method '" + pAuthMode + "' configured");
    }

    private void registerWhiteboardServlet(BundleContext pBundleContext) {
        ServletContextHelper contextHelper = this.getServletContextHelper();
        String agentContext = this.getServletContextPath();
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.name", "jolokia");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.path", agentContext);
        this.contextRegistration = pBundleContext.registerService(ServletContextHelper.class, (Object)contextHelper, properties);
        OsgiAgentServlet servlet = new OsgiAgentServlet(pBundleContext, this.restrictor);
        properties = new Hashtable();
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", "jolokia");
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.asyncSupported", Boolean.TRUE);
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/*");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", String.format("(%s=jolokia)", "osgi.http.whiteboard.context.name"));
        ((Dictionary)properties).put("load-on-startup", "0");
        Dictionary<String, String> config = this.getConfiguration();
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            ((Dictionary)properties).put("servlet.init." + key, config.get(key));
        }
        this.servletRegistration = pBundleContext.registerService(HttpServlet.class, (Object)servlet, properties);
    }
}

