/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.support.jmx.JsonDynamicMBeanImpl;
import org.jolokia.support.jmx.JsonMBean;

class JolokiaMBeanServerHandler
implements InvocationHandler {
    private final MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer();
    private final MBeanServer delegateServer;
    private final Set<ObjectName> delegatedMBeans = new HashSet<ObjectName>();
    private final Serializer serializer;

    public JolokiaMBeanServerHandler(Serializer pSerializer) {
        this.delegateServer = ManagementFactory.getPlatformMBeanServer();
        this.serializer = pSerializer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("registerMBean".equals(name)) {
            return this.registerMBean(args[0], (ObjectName)args[1]);
        }
        if ("unregisterMBean".equals(name)) {
            this.unregisterMBean((ObjectName)args[0]);
            return null;
        }
        try {
            return method.invoke((Object)this.mBeanServer, args);
        }
        catch (InvocationTargetException exp) {
            throw exp.getCause();
        }
    }

    private ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance ret = this.mBeanServer.registerMBean(object, name);
        JsonMBean anno = this.extractJsonMBeanAnnotation(object);
        if (anno != null) {
            ObjectName realName = ret.getObjectName();
            try {
                MBeanInfo info = this.mBeanServer.getMBeanInfo(realName);
                JsonDynamicMBeanImpl mbean = new JsonDynamicMBeanImpl(this.mBeanServer, realName, info, this.serializer, this.getJsonConverterOptions(anno));
                this.delegatedMBeans.add(realName);
                this.delegateServer.registerMBean(mbean, realName);
            }
            catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                throw new MBeanRegistrationException(e, "Cannot obtain MBeanInfo from Jolokia-Server for " + realName);
            }
        }
        return ret;
    }

    private void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mBeanServer.unregisterMBean(name);
        if (this.delegatedMBeans.contains(name)) {
            this.delegatedMBeans.remove(name);
            this.delegateServer.unregisterMBean(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonMBean extractJsonMBeanAnnotation(Object object) {
        JsonMBean anno;
        block11: {
            Class<?> clazz = object.getClass();
            anno = clazz.getAnnotation(JsonMBean.class);
            if (anno == null && ModelMBean.class.isAssignableFrom(object.getClass())) {
                Boolean isAccessible = null;
                Field field = null;
                try {
                    field = this.findField(clazz, "managedResource");
                    if (field != null) {
                        isAccessible = field.isAccessible();
                        field.setAccessible(true);
                        Object managedResource = field.get(object);
                        anno = managedResource.getClass().getAnnotation(JsonMBean.class);
                    }
                }
                catch (IllegalAccessException managedResource) {
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                        isAccessible = null;
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (isAccessible != null) {
                        field.setAccessible(isAccessible);
                    }
                }
            }
        }
        return anno;
    }

    private Field findField(Class<?> pClazz, String pField) {
        Class<?> c = pClazz;
        while (true) {
            try {
                return c.getDeclaredField(pField);
            }
            catch (NoSuchFieldException e) {
                if ((c = pClazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    private SerializeOptions getJsonConverterOptions(JsonMBean pAnno) {
        if (pAnno == null) {
            return SerializeOptions.DEFAULT;
        }
        ValueFaultHandler faultHandler = pAnno.faultHandling() == JsonMBean.FaultHandler.IGNORE_ERRORS ? ValueFaultHandler.IGNORING_VALUE_FAULT_HANDLER : ValueFaultHandler.THROWING_VALUE_FAULT_HANDLER;
        return new SerializeOptions.Builder().maxCollectionSize(pAnno.maxCollectionSize()).maxDepth(pAnno.maxDepth()).maxObjects(pAnno.maxObjects()).faultHandler(faultHandler).build();
    }
}

