/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.testkit.engine.Event;
import org.junit.platform.testkit.engine.Execution;
import org.junit.platform.testkit.engine.TerminationInfo;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class Executions {
    private final List<Execution> executions;
    private final String category;

    private Executions(Stream<Execution> executions, String category) {
        Preconditions.notNull(executions, (String)"Execution stream must not be null");
        this.executions = Collections.unmodifiableList(executions.collect(Collectors.toList()));
        this.category = category;
    }

    Executions(List<Event> events, String category) {
        Preconditions.notNull(events, (String)"Event list must not be null");
        Preconditions.containsNoNullElements(events, (String)"Event list must not contain null elements");
        this.executions = Collections.unmodifiableList(Executions.createExecutions(events));
        this.category = category;
    }

    public List<Execution> list() {
        return this.executions;
    }

    public Stream<Execution> stream() {
        return this.executions.stream();
    }

    public <R> Stream<R> map(Function<? super Execution, ? extends R> mapper) {
        Preconditions.notNull(mapper, (String)"Mapping function must not be null");
        return this.stream().map(mapper);
    }

    public Stream<Execution> filter(Predicate<? super Execution> predicate) {
        Preconditions.notNull(predicate, (String)"Filter predicate must not be null");
        return this.stream().filter(predicate);
    }

    public long count() {
        return this.executions.size();
    }

    public Executions skipped() {
        return new Executions(this.executionsByTerminationInfo(TerminationInfo::skipped), this.category + " Skipped");
    }

    public Executions started() {
        return new Executions(this.executionsByTerminationInfo(TerminationInfo::notSkipped), this.category + " Started");
    }

    public Executions finished() {
        return new Executions(this.finishedExecutions(), this.category + " Finished");
    }

    public Executions aborted() {
        return new Executions(this.finishedExecutionsByStatus(TestExecutionResult.Status.ABORTED), this.category + " Aborted");
    }

    public Executions succeeded() {
        return new Executions(this.finishedExecutionsByStatus(TestExecutionResult.Status.SUCCESSFUL), this.category + " Successful");
    }

    public Executions failed() {
        return new Executions(this.finishedExecutionsByStatus(TestExecutionResult.Status.FAILED), this.category + " Failed");
    }

    public ListAssert<Execution> assertThatExecutions() {
        return Assertions.assertThat(this.list());
    }

    public Executions debug() {
        this.debug(System.out);
        return this;
    }

    public Executions debug(OutputStream out) {
        Preconditions.notNull((Object)out, (String)"OutputStream must not be null");
        this.debug(new PrintWriter(out, true));
        return this;
    }

    public Executions debug(Writer writer) {
        Preconditions.notNull((Object)writer, (String)"Writer must not be null");
        this.debug(new PrintWriter(writer, true));
        return this;
    }

    private Executions debug(PrintWriter printWriter) {
        printWriter.println(this.category + " Executions:");
        this.executions.forEach(execution -> printWriter.printf("\t%s%n", execution));
        return this;
    }

    private Stream<Execution> finishedExecutions() {
        return this.executionsByTerminationInfo(TerminationInfo::executed);
    }

    private Stream<Execution> finishedExecutionsByStatus(TestExecutionResult.Status status) {
        Preconditions.notNull((Object)status, (String)"Status must not be null");
        return this.finishedExecutions().filter((? super T execution) -> execution.getTerminationInfo().getExecutionResult().getStatus() == status);
    }

    private Stream<Execution> executionsByTerminationInfo(Predicate<TerminationInfo> predicate) {
        return this.filter(execution -> predicate.test(execution.getTerminationInfo()));
    }

    private static List<Execution> createExecutions(List<Event> events) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        HashMap<TestDescriptor, Instant> executionStarts = new HashMap<TestDescriptor, Instant>();
        for (Event event : events) {
            switch (event.getType()) {
                case STARTED: {
                    executionStarts.put(event.getTestDescriptor(), event.getTimestamp());
                    break;
                }
                case SKIPPED: {
                    executionStarts.remove(event.getTestDescriptor());
                    Instant timestamp = event.getTimestamp();
                    Execution skippedEvent = Execution.skipped(event.getTestDescriptor(), timestamp, timestamp, event.getRequiredPayload(String.class));
                    executions.add(skippedEvent);
                    break;
                }
                case FINISHED: {
                    Instant startInstant = (Instant)executionStarts.remove(event.getTestDescriptor());
                    Instant endInstant = event.getTimestamp();
                    if (startInstant == null) break;
                    Execution finishedEvent = Execution.finished(event.getTestDescriptor(), startInstant, endInstant, event.getRequiredPayload(TestExecutionResult.class));
                    executions.add(finishedEvent);
                    break;
                }
            }
        }
        return executions;
    }
}

