/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.xslt;

public class UriTemplateParser {
    public static void parse(String template, Handler handler) {
        assert (template != null);
        assert (handler != null);
        int pos = 0;
        int length = template.length();
        State state = State.OutsideParam;
        StringBuilder builder = new StringBuilder();
        while (pos < length) {
            char c = template.charAt(pos++);
            switch (state) {
                case InsideParam: {
                    if (c == '}') {
                        if (builder.length() > 0) {
                            handler.handleParam(builder.toString());
                            builder.setLength(0);
                        }
                        state = State.OutsideParam;
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case OutsideParam: {
                    if (c == '{') {
                        if (builder.length() > 0) {
                            handler.handleText(builder.toString());
                            builder.setLength(0);
                        }
                        state = State.InsideParam;
                        break;
                    }
                    builder.append(c);
                }
            }
        }
        if (builder.length() > 0) {
            switch (state) {
                case InsideParam: {
                    handler.handleParam(builder.toString());
                    break;
                }
                case OutsideParam: {
                    handler.handleText(builder.toString());
                }
            }
        }
    }

    public static interface Handler {
        public void handleText(String var1);

        public void handleParam(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        InsideParam,
        OutsideParam;

    }
}

