/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.Collection;

public class StringUtil {
    public static boolean isBlank(String str) {
        return !StringUtil.isNotBlank(str);
    }

    public static boolean isNotBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String joinValuesWithLogicalCondition(String conditionText, Collection<String> values) {
        StringBuilder options = new StringBuilder();
        int i = 1;
        for (String o : values) {
            if (i == values.size()) {
                options.append(" " + conditionText + " ");
            } else if (i > 1) {
                options.append(", ");
            }
            options.append(o);
            ++i;
        }
        return options.toString();
    }

    public static String sanitizeSpacesAndQuotes(String str, Character quotes) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = null;
        for (int i = 0; i < str.length(); ++i) {
            char actualChar = str.charAt(i);
            if (Character.isWhitespace(actualChar) && actualChar != ' ' || actualChar == '\u00a0') {
                if (sb == null) {
                    sb = new StringBuilder(str.length() + 10).append(str.substring(0, i));
                }
                sb.append(' ');
                continue;
            }
            if (quotes != null && actualChar == quotes.charValue()) {
                if (sb == null) {
                    sb = new StringBuilder(str.length() + 10).append(str.substring(0, i));
                }
                sb.append('\\').append(actualChar);
                continue;
            }
            if (sb == null) continue;
            sb.append(actualChar);
        }
        return sb == null ? str : sb.toString();
    }
}

