/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlEntry;
import com.mongodb.client.model.mql.MqlExpression;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import java.time.Instant;
import java.util.ArrayList;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

@Beta(value={Beta.Reason.CLIENT})
public final class MqlValues {
    private MqlValues() {
    }

    public static MqlBoolean of(boolean of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonBoolean(of)));
    }

    public static MqlArray<MqlBoolean> ofBooleanArray(boolean ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonBoolean> list = new ArrayList<BsonBoolean>();
        for (boolean b : array) {
            list.add(new BsonBoolean(b));
        }
        return new MqlExpression<MqlBoolean>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(list)));
    }

    public static MqlInteger of(int of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonInt32(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(int ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonInt32> list = new ArrayList<BsonInt32>();
        for (int i : array) {
            list.add(new BsonInt32(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(list)));
    }

    public static MqlInteger of(long of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonInt64(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(long ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonInt64> list = new ArrayList<BsonInt64>();
        for (long i : array) {
            list.add(new BsonInt64(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(list)));
    }

    public static MqlNumber of(double of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonDouble(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(double ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDouble> list = new ArrayList<BsonDouble>();
        for (double n : array) {
            list.add(new BsonDouble(n));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(list)));
    }

    public static MqlNumber of(Decimal128 of) {
        Assertions.notNull("Decimal128", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonDecimal128(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(Decimal128 ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDecimal128> result = new ArrayList<BsonDecimal128>();
        for (Decimal128 e : array) {
            Assertions.notNull("elements of array", e);
            result.add(new BsonDecimal128(e));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(result)));
    }

    public static MqlDate of(Instant of) {
        Assertions.notNull("Instant", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder((BsonValue)new BsonDateTime(of.toEpochMilli())));
    }

    public static MqlArray<MqlDate> ofDateArray(Instant ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDateTime> result = new ArrayList<BsonDateTime>();
        for (Instant e : array) {
            Assertions.notNull("elements of array", e);
            result.add(new BsonDateTime(e.toEpochMilli()));
        }
        return new MqlExpression<MqlDate>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(result)));
    }

    public static MqlString of(String of) {
        Assertions.notNull("String", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(MqlValues.wrapString(of)));
    }

    public static MqlArray<MqlString> ofStringArray(String ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonValue> result = new ArrayList<BsonValue>();
        for (String e : array) {
            Assertions.notNull("elements of array", e);
            result.add(MqlValues.wrapString(e));
        }
        return new MqlExpression<MqlString>(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(result)));
    }

    private static BsonValue wrapString(String s) {
        BsonString bson = new BsonString(s);
        if (s.contains("$")) {
            return new BsonDocument("$literal", (BsonValue)bson);
        }
        return bson;
    }

    public static MqlDocument current() {
        return (MqlDocument)new MqlExpression(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    public static <R extends MqlValue> MqlMap<R> currentAsMap() {
        return (MqlMap)new MqlExpression(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    @SafeVarargs
    public static <T extends MqlValue> MqlArray<T> ofArray(T ... array) {
        Assertions.notNull("array", array);
        return new MqlExpression(cr -> {
            ArrayList<BsonValue> list = new ArrayList<BsonValue>();
            for (MqlValue v : array) {
                Assertions.notNull("elements of array", v);
                list.add(((MqlExpression)v).toBsonValue((CodecRegistry)cr));
            }
            return new MqlExpression.AstPlaceholder((BsonValue)new BsonArray(list));
        });
    }

    public static <T extends MqlValue> MqlEntry<T> ofEntry(MqlString k, T v) {
        Assertions.notNull("k", k);
        Assertions.notNull("v", v);
        return new MqlExpression(cr -> {
            BsonDocument document = new BsonDocument();
            document.put("k", MqlExpression.toBsonValue(cr, k));
            document.put("v", MqlExpression.toBsonValue(cr, v));
            return new MqlExpression.AstPlaceholder((BsonValue)document);
        });
    }

    public static <T extends MqlValue> MqlMap<T> ofMap() {
        return MqlValues.ofMap((Bson)new BsonDocument());
    }

    public static <T extends MqlValue> MqlMap<T> ofMap(Bson map) {
        Assertions.notNull("map", map);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonDocument("$literal", (BsonValue)map.toBsonDocument(BsonDocument.class, cr))));
    }

    public static MqlDocument of(Bson document) {
        Assertions.notNull("document", document);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonDocument("$literal", (BsonValue)document.toBsonDocument(BsonDocument.class, cr))));
    }

    public static MqlValue ofNull() {
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder((BsonValue)new BsonNull())).assertImplementsAllExpressions();
    }

    static MqlNumber numberToMqlNumber(Number number) {
        Assertions.notNull("number", number);
        if (number instanceof Integer) {
            return MqlValues.of((Integer)number);
        }
        if (number instanceof Long) {
            return MqlValues.of((Long)number);
        }
        if (number instanceof Double) {
            return MqlValues.of((Double)number);
        }
        if (number instanceof Decimal128) {
            return MqlValues.of((Decimal128)number);
        }
        throw new IllegalArgumentException("Number must be one of: Integer, Long, Double, Decimal128");
    }
}

